/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.elibracha.models.validations.ValidationResult;
import com.github.elibracha.models.validations.enums.ValidationStatus;
import com.github.elibracha.validators.Validator;
import java.util.Iterator;
import java.util.Map;

public class ParamsValidator
implements Validator {
    private final ValidationResult result = new ValidationResult();
    private JsonNode params;

    @Override
    public boolean validate() {
        Iterator<Map.Entry<String, JsonNode>> it = this.params.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> paramsScope = it.next();
            if (paramsScope.getValue() instanceof ArrayNode || paramsScope.getValue().asText().equals("$")) continue;
            this.result.setMessage(String.format("the method \"%s\" not a valid object parameters method", paramsScope.getKey()));
            this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
            return false;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setParams(tree);
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public JsonNode getParams() {
        return this.params;
    }

    public void setParams(JsonNode params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamsValidator)) {
            return false;
        }
        ParamsValidator other = (ParamsValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        JsonNode this$params = this.getParams();
        JsonNode other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParamsValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        JsonNode $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        return result;
    }

    public String toString() {
        return "ParamsValidator(result=" + this.getResult() + ", params=" + this.getParams() + ")";
    }
}

