/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.models.validations.ValidationResult;
import com.github.elibracha.models.validations.enums.ValidationStatus;
import com.github.elibracha.validators.HttpMethodValidator;
import com.github.elibracha.validators.Validator;
import java.util.Iterator;
import java.util.Map;

public class PathValidator
implements Validator {
    private static final String ENDPOINT_PATTERN = "(\\/[a-zA-Z{}1-9$*\\/]+)";
    private final HttpMethodValidator httpMethodValidator = new HttpMethodValidator();
    private final ValidationResult result = new ValidationResult();
    private JsonNode paths;

    @Override
    public boolean validate() {
        Iterator<Map.Entry<String, JsonNode>> it = this.paths.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> pathScope = it.next();
            if (pathScope.getKey().contains(",")) {
                for (String path : pathScope.getKey().split(",")) {
                    if (path.trim().equals("$") || path.trim().matches(ENDPOINT_PATTERN)) continue;
                    this.result.setMessage(String.format("value \"%s\" not a valid path", path.trim()));
                    this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
                    return false;
                }
            } else if (!pathScope.getKey().equals("$") && !pathScope.getKey().matches(ENDPOINT_PATTERN)) {
                this.result.setMessage(String.format("value \"%s\" not a valid path", pathScope.getKey().trim()));
                this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
                return false;
            }
            this.httpMethodValidator.setHttpMethod(pathScope.getValue());
            if (this.httpMethodValidator.validate()) continue;
            this.result.setMessage(this.httpMethodValidator.getResult().getMessage());
            this.result.setValidationStatus(this.httpMethodValidator.getResult().getValidationStatus());
            return false;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setPaths(tree);
    }

    public HttpMethodValidator getHttpMethodValidator() {
        return this.httpMethodValidator;
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public JsonNode getPaths() {
        return this.paths;
    }

    public void setPaths(JsonNode paths) {
        this.paths = paths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathValidator)) {
            return false;
        }
        PathValidator other = (PathValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpMethodValidator this$httpMethodValidator = this.getHttpMethodValidator();
        HttpMethodValidator other$httpMethodValidator = other.getHttpMethodValidator();
        if (this$httpMethodValidator == null ? other$httpMethodValidator != null : !((Object)this$httpMethodValidator).equals(other$httpMethodValidator)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        JsonNode this$paths = this.getPaths();
        JsonNode other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PathValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMethodValidator $httpMethodValidator = this.getHttpMethodValidator();
        result = result * 59 + ($httpMethodValidator == null ? 43 : ((Object)$httpMethodValidator).hashCode());
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        JsonNode $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : $paths.hashCode());
        return result;
    }

    public String toString() {
        return "PathValidator(httpMethodValidator=" + this.getHttpMethodValidator() + ", result=" + this.getResult() + ", paths=" + this.getPaths() + ")";
    }
}

