/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.elibracha.models.validations.ValidationResult;
import com.github.elibracha.models.validations.enums.ValidationStatus;
import com.github.elibracha.validators.Validator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SecurityValidator
implements Validator {
    private final ValidationResult result = new ValidationResult();
    private JsonNode security;

    @Override
    public boolean validate() {
        List targetStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.security.fields(), 16), true).collect(Collectors.toList());
        for (Map.Entry entry : targetStream) {
            if (entry.getValue() instanceof ArrayNode || ((JsonNode)entry.getValue()).asText().equals("$")) continue;
            this.result.setMessage(String.format("the method \"%s\" not a valid object security method", entry.getKey()));
            this.result.setValidationStatus(ValidationStatus.BAD_IGNORE_FILE);
            return false;
        }
        return true;
    }

    @Override
    public void setTree(JsonNode tree) {
        this.setSecurity(tree);
    }

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    public JsonNode getSecurity() {
        return this.security;
    }

    public void setSecurity(JsonNode security) {
        this.security = security;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityValidator)) {
            return false;
        }
        SecurityValidator other = (SecurityValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValidationResult this$result = this.getResult();
        ValidationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        JsonNode this$security = this.getSecurity();
        JsonNode other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        JsonNode $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : $security.hashCode());
        return result;
    }

    public String toString() {
        return "SecurityValidator(result=" + this.getResult() + ", security=" + this.getSecurity() + ")";
    }
}

