/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare;

import com.github.elibracha.compare.OpenApiDiff;
import com.github.elibracha.compare.ReferenceDiffCache;
import com.github.elibracha.model.ChangedHeader;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.utils.ChangedUtils;
import com.github.elibracha.utils.RefPointer;
import com.github.elibracha.utils.RefType;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.headers.Header;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;

public class HeaderDiff
extends ReferenceDiffCache<Header, ChangedHeader> {
    private static RefPointer<Header> refPointer = new RefPointer(RefType.HEADERS);
    private OpenApiDiff openApiDiff;
    private Components leftComponents;
    private Components rightComponents;

    public HeaderDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public Optional<ChangedHeader> diff(Header left, Header right, DiffContext context) {
        return this.cachedDiff(new HashSet<String>(), left, right, left.get$ref(), right.get$ref(), context);
    }

    @Override
    protected Optional<ChangedHeader> computeDiff(HashSet<String> refSet, Header left, Header right, DiffContext context) {
        left = refPointer.resolveRef(this.leftComponents, left, left.get$ref());
        right = refPointer.resolveRef(this.rightComponents, right, right.get$ref());
        ChangedHeader changedHeader = new ChangedHeader(left, right, context).setRequired(this.getBooleanDiff(left.getRequired(), right.getRequired())).setDeprecated(!Boolean.TRUE.equals(left.getDeprecated()) && Boolean.TRUE.equals(right.getDeprecated())).setStyle(!Objects.equals((Object)left.getStyle(), (Object)right.getStyle())).setExplode(this.getBooleanDiff(left.getExplode(), right.getExplode()));
        this.openApiDiff.getMetadataDiff().diff(left.getDescription(), right.getDescription(), context).ifPresent(changedHeader::setDescription);
        this.openApiDiff.getSchemaDiff().diff(new HashSet<String>(), left.getSchema(), right.getSchema(), context.copyWithRequired(true)).ifPresent(changedHeader::setSchema);
        this.openApiDiff.getContentDiff().diff(left.getContent(), right.getContent(), context).ifPresent(changedHeader::setContent);
        this.openApiDiff.getExtensionsDiff().diff(left.getExtensions(), right.getExtensions(), context).ifPresent(changedHeader::setExtensions);
        return ChangedUtils.isChanged(changedHeader);
    }

    private boolean getBooleanDiff(Boolean left, Boolean right) {
        boolean rightRequired;
        boolean leftRequired = Optional.ofNullable(left).orElse(Boolean.FALSE);
        return leftRequired != (rightRequired = Optional.ofNullable(right).orElse(Boolean.FALSE).booleanValue());
    }
}

