/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare;

import com.github.elibracha.compare.OpenApiDiff;
import com.github.elibracha.compare.ReferenceDiffCache;
import com.github.elibracha.model.ChangedParameter;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.utils.ChangedUtils;
import com.github.elibracha.utils.RefPointer;
import com.github.elibracha.utils.RefType;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;

public class ParameterDiff
extends ReferenceDiffCache<Parameter, ChangedParameter> {
    private static RefPointer<Parameter> refPointer = new RefPointer(RefType.PARAMETERS);
    private Components leftComponents;
    private Components rightComponents;
    private OpenApiDiff openApiDiff;

    public ParameterDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public Optional<ChangedParameter> diff(Parameter left, Parameter right, DiffContext context) {
        return this.cachedDiff(new HashSet<String>(), left, right, left.get$ref(), right.get$ref(), context);
    }

    @Override
    protected Optional<ChangedParameter> computeDiff(HashSet<String> refSet, Parameter left, Parameter right, DiffContext context) {
        left = refPointer.resolveRef(this.leftComponents, left, left.get$ref());
        right = refPointer.resolveRef(this.rightComponents, right, right.get$ref());
        ChangedParameter changedParameter = new ChangedParameter(right.getName(), right.getIn(), context).setOldParameter(left).setNewParameter(right).setChangeRequired(this.getBooleanDiff(left.getRequired(), right.getRequired())).setDeprecated(!Boolean.TRUE.equals(left.getDeprecated()) && Boolean.TRUE.equals(right.getDeprecated())).setChangeAllowEmptyValue(this.getBooleanDiff(left.getAllowEmptyValue(), right.getAllowEmptyValue())).setChangeStyle(!Objects.equals((Object)left.getStyle(), (Object)right.getStyle())).setChangeExplode(this.getBooleanDiff(left.getExplode(), right.getExplode()));
        this.openApiDiff.getSchemaDiff().diff(refSet, left.getSchema(), right.getSchema(), context.copyWithRequired(true)).ifPresent(changedParameter::setSchema);
        this.openApiDiff.getMetadataDiff().diff(left.getDescription(), right.getDescription(), context).ifPresent(changedParameter::setDescription);
        this.openApiDiff.getContentDiff().diff(left.getContent(), right.getContent(), context).ifPresent(changedParameter::setContent);
        this.openApiDiff.getExtensionsDiff().diff(left.getExtensions(), right.getExtensions(), context).ifPresent(changedParameter::setExtensions);
        return ChangedUtils.isChanged(changedParameter);
    }

    private boolean getBooleanDiff(Boolean left, Boolean right) {
        boolean rightRequired;
        boolean leftRequired = Optional.ofNullable(left).orElse(Boolean.FALSE);
        return leftRequired != (rightRequired = Optional.ofNullable(right).orElse(Boolean.FALSE).booleanValue());
    }
}

