/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.ObjectMapperFactory;
import com.github.elibracha.deserializers.AbstractDeserializer;
import com.github.elibracha.exceptions.SpecificationSupportException;
import com.github.elibracha.models.ignore.HttpMethodIgnore;
import com.github.elibracha.models.ignore.OperationIgnore;
import com.github.elibracha.models.validations.enums.HttpMethodSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HttpMethodDeserializer
extends AbstractDeserializer<HttpMethodIgnore> {
    public HttpMethodDeserializer() {
        super(HttpMethodIgnore.class);
    }

    @Override
    public HttpMethodIgnore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode httpMethods = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        HttpMethodIgnore httpMethodIgnore = (HttpMethodIgnore)this.preProcess(new HttpMethodIgnore(), httpMethods);
        Iterator<Map.Entry<String, JsonNode>> it = httpMethods.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> HttpMethodScope = it.next();
            OperationIgnore operationIgnore = ObjectMapperFactory.createYaml().convertValue((Object)HttpMethodScope.getValue(), OperationIgnore.class);
            if (this.checkWildCards(HttpMethodScope.getKey())) {
                List<String> keys = this.extractWildCards(HttpMethodScope.getKey());
                if (keys == null) {
                    List supported = Arrays.stream(HttpMethodSupport.values()).map(HttpMethodSupport::getValue).collect(Collectors.toList());
                    for (String sup : supported) {
                        this.setMethod(sup, httpMethodIgnore, operationIgnore);
                    }
                    continue;
                }
                for (String sup : keys) {
                    this.setMethod(sup, httpMethodIgnore, operationIgnore);
                }
                continue;
            }
            this.setMethod(HttpMethodScope.getKey(), httpMethodIgnore, operationIgnore);
        }
        return httpMethodIgnore;
    }

    private void setMethod(String key, HttpMethodIgnore httpMethodIgnore, OperationIgnore operationIgnore) throws SpecificationSupportException {
        switch (key) {
            case "post": {
                httpMethodIgnore.setPost(operationIgnore);
                break;
            }
            case "get": {
                httpMethodIgnore.setGet(operationIgnore);
                break;
            }
            case "put": {
                httpMethodIgnore.setPut(operationIgnore);
                break;
            }
            case "delete": {
                httpMethodIgnore.setDelete(operationIgnore);
                break;
            }
            case "head": {
                httpMethodIgnore.setHead(operationIgnore);
                break;
            }
            case "options": {
                httpMethodIgnore.setOptions(operationIgnore);
                break;
            }
            case "trace": {
                httpMethodIgnore.setTrace(operationIgnore);
                break;
            }
            case "patch": {
                httpMethodIgnore.setPatch(operationIgnore);
                break;
            }
            default: {
                throw new SpecificationSupportException(String.format("Specification does not support value \"%s\" as an http method, please referenced the documentation for supported entries.", key));
            }
        }
    }
}

