/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare;

import com.github.elibracha.compare.OpenApiDiff;
import com.github.elibracha.model.ChangedOAuthFlow;
import com.github.elibracha.utils.ChangedUtils;
import io.swagger.v3.oas.models.security.OAuthFlow;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OAuthFlowDiff {
    private OpenApiDiff openApiDiff;

    public OAuthFlowDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static Map<String, Object> getExtensions(OAuthFlow oAuthFlow) {
        return Optional.ofNullable(oAuthFlow).map(OAuthFlow::getExtensions).orElse(null);
    }

    public Optional<ChangedOAuthFlow> diff(OAuthFlow left, OAuthFlow right) {
        ChangedOAuthFlow changedOAuthFlow = new ChangedOAuthFlow(left, right);
        if (left != null && right != null) {
            changedOAuthFlow.setAuthorizationUrl(!Objects.equals(left.getAuthorizationUrl(), right.getAuthorizationUrl())).setTokenUrl(!Objects.equals(left.getTokenUrl(), right.getTokenUrl())).setRefreshUrl(!Objects.equals(left.getRefreshUrl(), right.getRefreshUrl()));
        }
        this.openApiDiff.getExtensionsDiff().diff(OAuthFlowDiff.getExtensions(left), OAuthFlowDiff.getExtensions(right)).ifPresent(changedOAuthFlow::setExtensions);
        return ChangedUtils.isChanged(changedOAuthFlow);
    }
}

