/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.compare;

import com.github.elibracha.compare.OpenApiDiff;
import com.github.elibracha.compare.ReferenceDiffCache;
import com.github.elibracha.model.ChangedRequestBody;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.utils.ChangedUtils;
import com.github.elibracha.utils.RefPointer;
import com.github.elibracha.utils.RefType;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public class RequestBodyDiff
extends ReferenceDiffCache<RequestBody, ChangedRequestBody> {
    private static RefPointer<RequestBody> refPointer = new RefPointer(RefType.REQUEST_BODIES);
    private OpenApiDiff openApiDiff;

    public RequestBodyDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static Map<String, Object> getExtensions(RequestBody body) {
        return Optional.ofNullable(body).map(RequestBody::getExtensions).orElse(null);
    }

    public Optional<ChangedRequestBody> diff(RequestBody left, RequestBody right, DiffContext context) {
        String leftRef = left != null ? left.get$ref() : null;
        String rightRef = right != null ? right.get$ref() : null;
        return this.cachedDiff(new HashSet<String>(), left, right, leftRef, rightRef, context);
    }

    @Override
    protected Optional<ChangedRequestBody> computeDiff(HashSet<String> refSet, RequestBody left, RequestBody right, DiffContext context) {
        Content oldRequestContent = new Content();
        Content newRequestContent = new Content();
        RequestBody oldRequestBody = null;
        RequestBody newRequestBody = null;
        if (left != null && (oldRequestBody = refPointer.resolveRef(this.openApiDiff.getOldSpecOpenApi().getComponents(), left, left.get$ref())).getContent() != null) {
            oldRequestContent = oldRequestBody.getContent();
        }
        if (right != null && (newRequestBody = refPointer.resolveRef(this.openApiDiff.getNewSpecOpenApi().getComponents(), right, right.get$ref())).getContent() != null) {
            newRequestContent = newRequestBody.getContent();
        }
        boolean leftRequired = oldRequestBody != null && Boolean.TRUE.equals(oldRequestBody.getRequired());
        boolean rightRequired = newRequestBody != null && Boolean.TRUE.equals(newRequestBody.getRequired());
        ChangedRequestBody changedRequestBody = new ChangedRequestBody(oldRequestBody, newRequestBody, context).setChangeRequired(leftRequired != rightRequired);
        this.openApiDiff.getMetadataDiff().diff(oldRequestBody != null ? oldRequestBody.getDescription() : null, newRequestBody != null ? newRequestBody.getDescription() : null, context).ifPresent(changedRequestBody::setDescription);
        this.openApiDiff.getContentDiff().diff(oldRequestContent, newRequestContent, context).ifPresent(changedRequestBody::setContent);
        this.openApiDiff.getExtensionsDiff().diff(RequestBodyDiff.getExtensions(left), RequestBodyDiff.getExtensions(right), context).ifPresent(changedRequestBody::setExtensions);
        return ChangedUtils.isChanged(changedRequestBody);
    }
}

