/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.processors;

import com.github.elibracha.model.ChangedSecurityRequirement;
import com.github.elibracha.model.ChangedSecurityRequirements;
import com.github.elibracha.models.ignore.SecurityIgnore;
import com.github.elibracha.models.ignore.SecurityProperty;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SecurityProcessor {
    public boolean apply(SecurityIgnore security, ChangedSecurityRequirements securityRequirements) {
        if (security.isIgnoreAll()) {
            return true;
        }
        ArrayList<ChangedSecurityRequirement> changeToRemove = new ArrayList<ChangedSecurityRequirement>();
        ArrayList<SecurityRequirement> missingToRemove = new ArrayList<SecurityRequirement>();
        ArrayList<SecurityRequirement> increasedToRemove = new ArrayList<SecurityRequirement>();
        if (securityRequirements != null) {
            boolean result;
            if (securityRequirements.getChanged() != null) {
                for (ChangedSecurityRequirement changedSecurityRequirement : securityRequirements.getChanged()) {
                    result = this.processRequirement(changedSecurityRequirement.getOldSecurityRequirement(), security.getSecurity());
                    if (!result) continue;
                    changeToRemove.add(changedSecurityRequirement);
                }
                securityRequirements.getChanged().removeAll(changeToRemove);
            }
            if (securityRequirements.getMissing() != null) {
                for (SecurityRequirement securityRequirement : securityRequirements.getMissing()) {
                    result = this.processRequirement(securityRequirement, security.getSecurity());
                    if (!result) continue;
                    missingToRemove.add(securityRequirement);
                }
                securityRequirements.getMissing().removeAll(missingToRemove);
            }
            if (securityRequirements.getIncreased() != null) {
                for (SecurityRequirement securityRequirement : securityRequirements.getIncreased()) {
                    result = this.processRequirement(securityRequirement, security.getSecurity());
                    if (!result) continue;
                    increasedToRemove.add(securityRequirement);
                }
                securityRequirements.getIncreased().removeAll(increasedToRemove);
            }
        }
        return !(securityRequirements.getChanged() != null && securityRequirements.getChanged().size() != 0 || securityRequirements.getMissing() != null && securityRequirements.getMissing().size() != 0 || securityRequirements.getIncreased() != null && securityRequirements.getIncreased().size() != 0);
    }

    private boolean processRequirement(SecurityRequirement oldSecurityRequirement, Map<String, SecurityProperty> security) {
        ArrayList keysToRemove = new ArrayList();
        for (Map.Entry entry : oldSecurityRequirement.entrySet()) {
            SecurityProperty securityProperty = security.get(entry.getKey());
            if (securityProperty == null) continue;
            List newValue = ((List)entry.getValue()).stream().filter(e -> !securityProperty.getProperties().contains(e)).collect(Collectors.toList());
            if (newValue.size() == 0) {
                keysToRemove.add(entry.getKey());
            }
            entry.setValue(newValue);
        }
        oldSecurityRequirement.keySet().removeAll(keysToRemove);
        return oldSecurityRequirement.size() == 0;
    }
}

