/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.elibracha.ObjectMapperFactory;
import com.github.elibracha.deserializers.AbstractDeserializer;
import com.github.elibracha.exceptions.SpecificationSupportException;
import com.github.elibracha.models.ignore.OperationIgnore;
import com.github.elibracha.models.ignore.ParametersIgnore;
import com.github.elibracha.models.ignore.RequestIgnore;
import com.github.elibracha.models.ignore.ResponseIgnore;
import com.github.elibracha.models.ignore.SecurityIgnore;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class OperationDeserializer
extends AbstractDeserializer<OperationIgnore> {
    public OperationDeserializer() {
        super(OperationIgnore.class);
    }

    @Override
    public OperationIgnore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode operation = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        OperationIgnore operationIgnore = (OperationIgnore)this.preProcess(new OperationIgnore(), operation);
        Iterator<Map.Entry<String, JsonNode>> it = operation.fields();
        block12: while (it.hasNext()) {
            Map.Entry<String, JsonNode> operationScope = it.next();
            switch (operationScope.getKey()) {
                case "parameters": {
                    ParametersIgnore parametersIgnore = ObjectMapperFactory.createYaml().convertValue((Object)operationScope.getValue(), ParametersIgnore.class);
                    operationIgnore.setParameters(parametersIgnore);
                    continue block12;
                }
                case "request": {
                    RequestIgnore requestIgnore = ObjectMapperFactory.createYaml().convertValue((Object)operationScope.getValue(), RequestIgnore.class);
                    operationIgnore.setRequest(requestIgnore);
                    continue block12;
                }
                case "response": {
                    ResponseIgnore responseIgnore = ObjectMapperFactory.createYaml().convertValue((Object)operationScope.getValue(), ResponseIgnore.class);
                    operationIgnore.setResponse(responseIgnore);
                    continue block12;
                }
                case "security": {
                    SecurityIgnore securityIgnore = ObjectMapperFactory.createYaml().convertValue((Object)operationScope.getValue(), SecurityIgnore.class);
                    operationIgnore.setSecurity(securityIgnore);
                    continue block12;
                }
            }
            throw new SpecificationSupportException(String.format("Specification does not support value \"%s\" as an operation to ignore, please referenced the documentation for supported entries.", operationScope.getKey()));
        }
        return operationIgnore;
    }
}

