/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.elibracha.model.Changed;
import com.github.elibracha.model.ChangedExtensions;
import com.github.elibracha.model.ChangedOperation;
import com.github.elibracha.model.ComposedChanged;
import com.github.elibracha.model.DiffResult;
import com.github.elibracha.model.Endpoint;
import com.github.elibracha.utils.EndpointUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"oldSpecOpenApi", "newSpecOpenApi", "oldSpecOpenApi", "newSpecOpenApi"})
public class ChangedOpenApi
implements ComposedChanged {
    private OpenAPI oldSpecOpenApi;
    private OpenAPI newSpecOpenApi;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Endpoint> newEndpoints;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Endpoint> missingEndpoints;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ChangedOperation> changedOperations;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ChangedExtensions changedExtensions;

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Endpoint> getDeprecatedEndpoints() {
        return this.changedOperations.stream().filter(ChangedOperation::isDeprecated).map(c -> EndpointUtils.convert2Endpoint(c.getPathUrl(), c.getHttpMethod(), c.getNewOperation())).collect(Collectors.toList());
    }

    @Override
    public List<Changed> getChangedElements() {
        return Stream.concat(this.changedOperations.stream(), Stream.of(this.changedExtensions)).collect(Collectors.toList());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.newEndpoints.isEmpty() && this.missingEndpoints.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (this.missingEndpoints.isEmpty()) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public OpenAPI getOldSpecOpenApi() {
        return this.oldSpecOpenApi;
    }

    public OpenAPI getNewSpecOpenApi() {
        return this.newSpecOpenApi;
    }

    public List<Endpoint> getNewEndpoints() {
        return this.newEndpoints;
    }

    public List<Endpoint> getMissingEndpoints() {
        return this.missingEndpoints;
    }

    public List<ChangedOperation> getChangedOperations() {
        return this.changedOperations;
    }

    public ChangedExtensions getChangedExtensions() {
        return this.changedExtensions;
    }

    public ChangedOpenApi setOldSpecOpenApi(OpenAPI oldSpecOpenApi) {
        this.oldSpecOpenApi = oldSpecOpenApi;
        return this;
    }

    public ChangedOpenApi setNewSpecOpenApi(OpenAPI newSpecOpenApi) {
        this.newSpecOpenApi = newSpecOpenApi;
        return this;
    }

    public ChangedOpenApi setNewEndpoints(List<Endpoint> newEndpoints) {
        this.newEndpoints = newEndpoints;
        return this;
    }

    public ChangedOpenApi setMissingEndpoints(List<Endpoint> missingEndpoints) {
        this.missingEndpoints = missingEndpoints;
        return this;
    }

    public ChangedOpenApi setChangedOperations(List<ChangedOperation> changedOperations) {
        this.changedOperations = changedOperations;
        return this;
    }

    public ChangedOpenApi setChangedExtensions(ChangedExtensions changedExtensions) {
        this.changedExtensions = changedExtensions;
        return this;
    }
}

