/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.model;

import com.github.elibracha.model.ChangedOperation;
import com.github.elibracha.model.Endpoint;

public class ChangedOpenApiRender {
    String name;
    String httpMehhod;
    String whatChanged;
    String isBreaking;

    public ChangedOpenApiRender(String name, String httpMehhod, String whatChanged, String isBreaking) {
        this.name = name;
        this.httpMehhod = httpMehhod;
        this.isBreaking = isBreaking;
    }

    public ChangedOpenApiRender(Endpoint endpoint, String _whatChanged) {
        this.name = endpoint.getPathUrl();
        this.httpMehhod = endpoint.getMethod().toString();
        this.whatChanged = _whatChanged;
        this.isBreaking = "Breaking";
    }

    public ChangedOpenApiRender(ChangedOperation changedOperation) {
        this.name = changedOperation.getPathUrl();
        this.httpMehhod = changedOperation.getHttpMethod().toString();
        this.whatChanged = this.getApiResponse(changedOperation);
        if (this.whatChanged != null) {
            this.isBreaking = "Breaking";
        }
    }

    public String getApiResponse(ChangedOperation changedOperation) {
        if (changedOperation.getApiResponses() != null) {
            if (changedOperation.getApiResponses().getIncreased().size() > 0) {
                return "AddedEndPoint";
            }
            if (changedOperation.getApiResponses().getMissing().size() > 0) {
                return "DeletedEndPoint";
            }
            if (changedOperation.getApiResponses().getChanged().size() > 0) {
                return "ChangedEndPoint";
            }
        }
        return "ChangedEndPoint";
    }

    public String getName() {
        return this.name;
    }

    public String getHttpMehhod() {
        return this.httpMehhod;
    }

    public String getWhatChanged() {
        return this.whatChanged;
    }

    public String getIsBreaking() {
        return this.isBreaking;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHttpMehhod(String httpMehhod) {
        this.httpMehhod = httpMehhod;
    }

    public void setWhatChanged(String whatChanged) {
        this.whatChanged = whatChanged;
    }

    public void setIsBreaking(String isBreaking) {
        this.isBreaking = isBreaking;
    }
}

