/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.elibracha.model.Changed;
import com.github.elibracha.model.ChangedExtensions;
import com.github.elibracha.model.ChangedOperation;
import com.github.elibracha.model.ComposedChanged;
import com.github.elibracha.model.DiffContext;
import com.github.elibracha.model.DiffResult;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"pathUrl", "oldPath", "newPath", "context", "extensions"})
public class ChangedPath
implements ComposedChanged {
    private final String pathUrl;
    private final PathItem oldPath;
    private final PathItem newPath;
    private final DiffContext context;
    Map<PathItem.HttpMethod, Operation> increased;
    Map<PathItem.HttpMethod, Operation> missing;
    List<ChangedOperation> changed;
    private ChangedExtensions extensions;

    public ChangedPath(String pathUrl, PathItem oldPath, PathItem newPath, DiffContext context) {
        this.pathUrl = pathUrl;
        this.oldPath = oldPath;
        this.newPath = newPath;
        this.context = context;
        this.increased = new LinkedHashMap<PathItem.HttpMethod, Operation>();
        this.missing = new LinkedHashMap<PathItem.HttpMethod, Operation>();
        this.changed = new ArrayList<ChangedOperation>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return Stream.concat(this.changed.stream(), Stream.of(this.extensions)).collect(Collectors.toList());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (this.missing.isEmpty()) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public String getPathUrl() {
        return this.pathUrl;
    }

    public PathItem getOldPath() {
        return this.oldPath;
    }

    public PathItem getNewPath() {
        return this.newPath;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Map<PathItem.HttpMethod, Operation> getIncreased() {
        return this.increased;
    }

    public Map<PathItem.HttpMethod, Operation> getMissing() {
        return this.missing;
    }

    public List<ChangedOperation> getChanged() {
        return this.changed;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedPath setIncreased(Map<PathItem.HttpMethod, Operation> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedPath setMissing(Map<PathItem.HttpMethod, Operation> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedPath setChanged(List<ChangedOperation> changed) {
        this.changed = changed;
        return this;
    }

    public ChangedPath setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }
}

