/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.elibracha.model.Changed;
import com.github.elibracha.model.ChangedPath;
import com.github.elibracha.model.ComposedChanged;
import com.github.elibracha.model.DiffResult;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"oldPathMap", "newPathMap"})
public class ChangedPaths
implements ComposedChanged {
    private final Map<String, PathItem> oldPathMap;
    private final Map<String, PathItem> newPathMap;
    private Map<String, PathItem> increased;
    private Map<String, PathItem> missing;
    private Map<String, ChangedPath> changed;

    public ChangedPaths(Map<String, PathItem> oldPathMap, Map<String, PathItem> newPathMap) {
        this.oldPathMap = oldPathMap;
        this.newPathMap = newPathMap;
        this.increased = new LinkedHashMap<String, PathItem>();
        this.missing = new LinkedHashMap<String, PathItem>();
        this.changed = new LinkedHashMap<String, ChangedPath>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed.values());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (this.missing.isEmpty()) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public Map<String, PathItem> getOldPathMap() {
        return this.oldPathMap;
    }

    public Map<String, PathItem> getNewPathMap() {
        return this.newPathMap;
    }

    public Map<String, PathItem> getIncreased() {
        return this.increased;
    }

    public Map<String, PathItem> getMissing() {
        return this.missing;
    }

    public Map<String, ChangedPath> getChanged() {
        return this.changed;
    }

    public void setIncreased(Map<String, PathItem> increased) {
        this.increased = increased;
    }

    public void setMissing(Map<String, PathItem> missing) {
        this.missing = missing;
    }

    public void setChanged(Map<String, ChangedPath> changed) {
        this.changed = changed;
    }
}

