/*
 * Decompiled with CFR 0.152.
 */
package com.github.elibracha.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.elibracha.model.Changed;
import com.github.elibracha.model.ChangedSecurityScheme;
import com.github.elibracha.model.ComposedChanged;
import com.github.elibracha.model.DiffResult;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"oldSecurityRequirements", "newSecurityRequirements"})
public class ChangedSecurityRequirement
implements ComposedChanged {
    private SecurityRequirement oldSecurityRequirement;
    private SecurityRequirement newSecurityRequirement;
    private SecurityRequirement missing;
    private SecurityRequirement increased;
    private List<ChangedSecurityScheme> changed;

    public ChangedSecurityRequirement(SecurityRequirement oldSecurityRequirement, SecurityRequirement newSecurityRequirement) {
        this.oldSecurityRequirement = oldSecurityRequirement;
        this.newSecurityRequirement = newSecurityRequirement;
        this.changed = new ArrayList<ChangedSecurityScheme>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased == null && this.missing == null) {
            return DiffResult.NO_CHANGES;
        }
        if (this.increased == null) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public void addMissing(String key, List<String> scopes) {
        if (this.missing == null) {
            this.missing = new SecurityRequirement();
        }
        this.missing.put(key, scopes);
    }

    public void addIncreased(String key, List<String> scopes) {
        if (this.increased == null) {
            this.increased = new SecurityRequirement();
        }
        this.increased.put(key, scopes);
    }

    public void addChanged(ChangedSecurityScheme changedSecurityScheme) {
        this.changed.add(changedSecurityScheme);
    }

    public SecurityRequirement getOldSecurityRequirement() {
        return this.oldSecurityRequirement;
    }

    public SecurityRequirement getNewSecurityRequirement() {
        return this.newSecurityRequirement;
    }

    public SecurityRequirement getMissing() {
        return this.missing;
    }

    public SecurityRequirement getIncreased() {
        return this.increased;
    }

    public List<ChangedSecurityScheme> getChanged() {
        return this.changed;
    }

    public ChangedSecurityRequirement setOldSecurityRequirement(SecurityRequirement oldSecurityRequirement) {
        this.oldSecurityRequirement = oldSecurityRequirement;
        return this;
    }

    public ChangedSecurityRequirement setNewSecurityRequirement(SecurityRequirement newSecurityRequirement) {
        this.newSecurityRequirement = newSecurityRequirement;
        return this;
    }

    public ChangedSecurityRequirement setMissing(SecurityRequirement missing) {
        this.missing = missing;
        return this;
    }

    public ChangedSecurityRequirement setIncreased(SecurityRequirement increased) {
        this.increased = increased;
        return this;
    }

    public ChangedSecurityRequirement setChanged(List<ChangedSecurityScheme> changed) {
        this.changed = changed;
        return this;
    }
}

