/*
 * Decompiled with CFR 0.152.
 */
package com.github.esrrhs.fakescript;

import com.github.esrrhs.fakescript.command;
import com.github.esrrhs.fakescript.container_addr;
import com.github.esrrhs.fakescript.fake;
import com.github.esrrhs.fakescript.func_binary;
import com.github.esrrhs.fakescript.opt_ins;
import com.github.esrrhs.fakescript.opt_ins_addr;
import com.github.esrrhs.fakescript.stack_variant_info;
import com.github.esrrhs.fakescript.types;
import com.github.esrrhs.fakescript.variant;
import java.util.ArrayList;
import java.util.HashSet;

class optimizer {
    private fake m_f;
    private boolean isopt;
    private ArrayList<opt_ins> inslist = new ArrayList();
    private boolean isopen;

    public optimizer(fake f) {
        this.m_f = f;
    }

    public void open() {
        this.isopen = true;
    }

    public void close() {
        this.isopen = false;
    }

    public void optimize(func_binary fb) throws Exception {
        if (!this.isopen) {
            return;
        }
        types.log(this.m_f, "before %s", fb.dump(-1));
        while (true) {
            this.isopt = false;
            this.trans_inslist(fb);
            if (!this.isopt) {
                this.optimize_write_assign(fb);
            }
            if (!this.isopt) {
                this.optimize_write_write(fb);
            }
            if (!this.isopt) {
                this.optimize_assign_read(fb);
            }
            if (!this.isopt) {
                this.optimize_no_use_const(fb);
            }
            if (!this.isopt) {
                this.optimize_no_use_container(fb);
            }
            if (!this.isopt) {
                this.optimize_no_use_stack(fb);
            }
            if (!this.isopt) {
                this.optimize_stack_pos(fb);
            }
            if (!this.isopt) break;
            types.log(this.m_f, "optimize %s", fb.dump(-1));
        }
    }

    private void optimize_no_use_stack(func_binary fb) {
        for (int i = 0; i < fb.m_debug_stack_variant_info.length; ++i) {
            int z;
            int j;
            stack_variant_info info = fb.m_debug_stack_variant_info[i];
            int pos = info.m_pos;
            if (pos < fb.m_paramnum) continue;
            boolean use = false;
            for (j = 0; j < fb.m_buff.length; ++j) {
                long cmd = fb.m_buff[j];
                if (!this.is_addr_type(cmd, 0, pos)) continue;
                use = true;
                break;
            }
            for (j = 0; j < fb.m_container_addr_list.length; ++j) {
                container_addr addr = fb.m_container_addr_list[j];
                if (this.is_addr_type(addr.m_con, 0, pos)) {
                    use = true;
                    break;
                }
                if (!this.is_addr_type(addr.m_key, 0, pos)) continue;
                use = true;
                break;
            }
            if (use) continue;
            stack_variant_info[] newlist = new stack_variant_info[fb.m_debug_stack_variant_info.length - 1];
            for (z = 0; z < i; ++z) {
                newlist[z] = fb.m_debug_stack_variant_info[z];
            }
            for (z = i; z < fb.m_debug_stack_variant_info.length - 1; ++z) {
                newlist[z] = fb.m_debug_stack_variant_info[z + 1];
            }
            fb.m_debug_stack_variant_info = newlist;
            this.isopt = true;
        }
    }

    private void optimize_no_use_container(func_binary fb) {
        for (int i = 0; i < fb.m_container_addr_list.length; ++i) {
            int j;
            int j2;
            boolean use = false;
            for (j2 = 0; j2 < fb.m_buff.length; ++j2) {
                long cmd = fb.m_buff[j2];
                if (!this.is_addr_type(cmd, 2, i)) continue;
                use = true;
                break;
            }
            for (j2 = 0; j2 < fb.m_container_addr_list.length; ++j2) {
                container_addr addr = fb.m_container_addr_list[j2];
                if (this.is_addr_type(addr.m_con, 2, i)) {
                    use = true;
                    break;
                }
                if (!this.is_addr_type(addr.m_key, 2, i)) continue;
                use = true;
                break;
            }
            if (use) continue;
            for (j2 = i; j2 < fb.m_container_addr_list.length - 1; ++j2) {
                this.replace_all_addr(fb, 2, j2 + 1, j2);
            }
            container_addr[] newlist = new container_addr[fb.m_container_addr_list.length - 1];
            for (j = 0; j < i; ++j) {
                newlist[j] = fb.m_container_addr_list[j];
            }
            for (j = i; j < fb.m_container_addr_list.length - 1; ++j) {
                newlist[j] = fb.m_container_addr_list[j + 1];
            }
            fb.m_container_addr_list = newlist;
            this.isopt = true;
            return;
        }
    }

    private void optimize_no_use_const(func_binary fb) {
        for (int i = 0; i < fb.m_const_list.length; ++i) {
            int j;
            int j2;
            boolean use = false;
            for (j2 = 0; j2 < fb.m_buff.length; ++j2) {
                long cmd = fb.m_buff[j2];
                if (!this.is_addr_type(cmd, 1, i)) continue;
                use = true;
                break;
            }
            for (j2 = 0; j2 < fb.m_container_addr_list.length; ++j2) {
                container_addr addr = fb.m_container_addr_list[j2];
                if (this.is_addr_type(addr.m_con, 1, i)) {
                    use = true;
                    break;
                }
                if (!this.is_addr_type(addr.m_key, 1, i)) continue;
                use = true;
                break;
            }
            if (use) continue;
            for (j2 = i; j2 < fb.m_const_list.length - 1; ++j2) {
                this.replace_all_addr(fb, 1, j2 + 1, j2);
            }
            variant[] newlist = new variant[fb.m_const_list.length - 1];
            for (j = 0; j < i; ++j) {
                newlist[j] = fb.m_const_list[j];
            }
            for (j = i; j < fb.m_const_list.length - 1; ++j) {
                newlist[j] = fb.m_const_list[j + 1];
            }
            fb.m_const_list = newlist;
            this.isopt = true;
            return;
        }
    }

    private boolean is_addr_type(long cmd, int dsttype, int dstpos) {
        int type = command.COMMAND_TYPE(cmd);
        int code = command.COMMAND_CODE(cmd);
        if (type == 1) {
            short addrtype = command.HIINT16(code);
            short pos = command.LOINT16(code);
            if (addrtype == dsttype && pos == dstpos) {
                return true;
            }
        }
        return false;
    }

    private void replace_all_addr(func_binary fb, int dsttype, int frompos, int topos) {
        int j;
        for (j = 0; j < fb.m_buff.length; ++j) {
            long cmd = fb.m_buff[j];
            fb.m_buff[j] = this.replace_addr_cmd(cmd, dsttype, frompos, topos);
        }
        for (j = 0; j < fb.m_container_addr_list.length; ++j) {
            container_addr addr = fb.m_container_addr_list[j];
            addr.m_con = this.replace_addr_cmd(addr.m_con, dsttype, frompos, topos);
            addr.m_key = this.replace_addr_cmd(addr.m_key, dsttype, frompos, topos);
        }
    }

    private long replace_addr_cmd(long cmd, int dsttype, int frompos, int topos) {
        int type = command.COMMAND_TYPE(cmd);
        int code = command.COMMAND_CODE(cmd);
        if (type == 1) {
            short addrtype = command.HIINT16(code);
            int pos = command.LOINT16(code);
            if (addrtype == dsttype && pos == frompos) {
                pos = topos;
                cmd = command.MAKE_ADDR(addrtype, pos);
            }
        }
        return cmd;
    }

    private void optimize_stack_pos(func_binary fb) {
        int i;
        int j;
        HashSet<Integer> set = new HashSet<Integer>();
        int max = -1;
        for (j = 0; j < fb.m_paramnum; ++j) {
            set.add(j);
            if (j <= max) continue;
            max = j;
        }
        for (j = 0; j < fb.m_buff.length; ++j) {
            long cmd = fb.m_buff[j];
            int type = command.COMMAND_TYPE(cmd);
            int code = command.COMMAND_CODE(cmd);
            if (type != 1) continue;
            short addrtype = command.HIINT16(code);
            short pos = command.LOINT16(code);
            if (addrtype != 0) continue;
            set.add(Integer.valueOf(pos));
            if (pos <= max) continue;
            max = pos;
        }
        for (j = 0; j < fb.m_container_addr_list.length; ++j) {
            short pos;
            short addrtype;
            container_addr addr = fb.m_container_addr_list[j];
            long cmd = addr.m_con;
            int type = command.COMMAND_TYPE(cmd);
            int code = command.COMMAND_CODE(cmd);
            if (type == 1) {
                addrtype = command.HIINT16(code);
                pos = command.LOINT16(code);
                if (addrtype == 0) {
                    set.add(Integer.valueOf(pos));
                    if (pos > max) {
                        max = pos;
                    }
                }
            }
            cmd = addr.m_key;
            type = command.COMMAND_TYPE(cmd);
            code = command.COMMAND_CODE(cmd);
            if (type != 1) continue;
            addrtype = command.HIINT16(code);
            pos = command.LOINT16(code);
            if (addrtype != 0) continue;
            set.add(Integer.valueOf(pos));
            if (pos <= max) continue;
            max = pos;
        }
        if (set.size() == max + 1) {
            return;
        }
        int empty = -1;
        for (int j2 = 0; j2 < max + 1; ++j2) {
            if (set.contains(j2)) continue;
            empty = j2;
            break;
        }
        for (i = empty; i < max; ++i) {
            this.replace_all_addr(fb, 0, i + 1, i);
        }
        for (i = empty; i < max; ++i) {
            stack_variant_info info;
            int j3;
            for (j3 = 0; j3 < fb.m_debug_stack_variant_info.length; ++j3) {
                int z;
                info = fb.m_debug_stack_variant_info[j3];
                if (info.m_pos != i) continue;
                stack_variant_info[] newlist = new stack_variant_info[fb.m_debug_stack_variant_info.length - 1];
                for (z = 0; z < j3; ++z) {
                    newlist[z] = fb.m_debug_stack_variant_info[z];
                }
                for (z = j3; z < fb.m_debug_stack_variant_info.length - 1; ++z) {
                    newlist[z] = fb.m_debug_stack_variant_info[z + 1];
                }
                fb.m_debug_stack_variant_info = newlist;
                break;
            }
            for (j3 = 0; j3 < fb.m_debug_stack_variant_info.length; ++j3) {
                info = fb.m_debug_stack_variant_info[j3];
                if (info.m_pos != i + 1) continue;
                info.m_pos = i;
            }
        }
        this.isopt = true;
    }

    private void set_ins_write(opt_ins ins, func_binary fb, int ip) {
        long v_cmd = fb.m_buff[ip];
        ins.dst.add(new opt_ins_addr(ip, v_cmd));
        this.set_ins_write_by_cmd(ins, fb, v_cmd);
    }

    private void set_ins_write_by_cmd(opt_ins ins, func_binary fb, long v_cmd) {
        short v_addrtype = command.ADDR_TYPE(command.COMMAND_CODE(v_cmd));
        short v_addrpos = command.ADDR_POS(command.COMMAND_CODE(v_cmd));
        if (v_addrtype == 0) {
            ins.write.add(v_cmd);
        } else if (v_addrtype != 1 && v_addrtype == 2) {
            container_addr ca = fb.m_container_addr_list[v_addrpos];
            this.set_ins_read_by_cmd(ins, fb, ca.m_con);
            this.set_ins_write_by_cmd(ins, fb, ca.m_con);
            this.set_ins_read_by_cmd(ins, fb, ca.m_key);
        }
    }

    private void set_ins_read(opt_ins ins, func_binary fb, int ip) {
        long v_cmd = fb.m_buff[ip];
        ins.src.add(new opt_ins_addr(ip, v_cmd));
        this.set_ins_read_by_cmd(ins, fb, v_cmd);
    }

    private void set_ins_read_by_cmd(opt_ins ins, func_binary fb, long v_cmd) {
        short v_addrtype = command.ADDR_TYPE(command.COMMAND_CODE(v_cmd));
        short v_addrpos = command.ADDR_POS(command.COMMAND_CODE(v_cmd));
        if (v_addrtype == 0) {
            ins.read.add(v_cmd);
        } else if (v_addrtype != 1 && v_addrtype == 2) {
            container_addr ca = fb.m_container_addr_list[v_addrpos];
            this.set_ins_read_by_cmd(ins, fb, ca.m_con);
            this.set_ins_write_by_cmd(ins, fb, ca.m_con);
            this.set_ins_read_by_cmd(ins, fb, ca.m_key);
        }
    }

    private void trans_inslist(func_binary fb) throws Exception {
        this.inslist.clear();
        int ip = 0;
        while (ip < fb.m_buff.length) {
            int code = command.COMMAND_CODE(fb.m_buff[ip]);
            opt_ins ins = new opt_ins();
            ins.code = code;
            ins.offset = ip++;
            this.inslist.add(ins);
            switch (code) {
                case 0: {
                    this.set_ins_write(ins, fb, ip);
                    this.set_ins_read(ins, fb, ++ip);
                    ++ip;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.set_ins_read(ins, fb, ip);
                    this.set_ins_read(ins, fb, ++ip);
                    this.set_ins_write(ins, fb, ++ip);
                    ++ip;
                    break;
                }
                case 25: {
                    this.set_ins_read(ins, fb, ip);
                    this.set_ins_write(ins, fb, ++ip);
                    ++ip;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    this.set_ins_read(ins, fb, ip);
                    this.set_ins_read(ins, fb, ++ip);
                    ++ip;
                    ++ip;
                    ++ip;
                    break;
                }
                case 34: {
                    this.set_ins_read(ins, fb, ip);
                    ++ip;
                    ++ip;
                    ++ip;
                    break;
                }
                case 13: {
                    this.set_ins_read(ins, fb, ip);
                    ++ip;
                    ++ip;
                    break;
                }
                case 14: {
                    ++ip;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.set_ins_read(ins, fb, ip);
                    this.set_ins_write(ins, fb, ip);
                    this.set_ins_read(ins, fb, ++ip);
                    ++ip;
                    break;
                }
                case 35: {
                    int i;
                    this.set_ins_read(ins, fb, ++ip);
                    int retnum = command.COMMAND_CODE(fb.m_buff[++ip]);
                    ++ip;
                    for (i = 0; i < retnum; ++i) {
                        this.set_ins_write(ins, fb, ip);
                        ++ip;
                    }
                    int argnum = command.COMMAND_CODE(fb.m_buff[ip]);
                    ++ip;
                    for (int i2 = 0; i2 < argnum; ++i2) {
                        this.set_ins_write(ins, fb, ip);
                        this.set_ins_read(ins, fb, ip);
                        ++ip;
                    }
                    break;
                }
                case 12: {
                    int i;
                    int returnnum = command.COMMAND_CODE(fb.m_buff[ip]);
                    ++ip;
                    for (i = 0; i < returnnum; ++i) {
                        this.set_ins_read(ins, fb, ip);
                        ++ip;
                    }
                    break;
                }
                case 15: {
                    this.set_ins_read(ins, fb, ip);
                    this.set_ins_write(ins, fb, ip);
                    this.set_ins_read(ins, fb, ++ip);
                    this.set_ins_read(ins, fb, ++ip);
                    this.set_ins_read(ins, fb, ++ip);
                    ++ip;
                    ++ip;
                    break;
                }
                case 16: {
                    this.set_ins_read(ins, fb, ip);
                    this.set_ins_write(ins, fb, ip);
                    this.set_ins_read(ins, fb, ++ip);
                    this.set_ins_read(ins, fb, ++ip);
                    ++ip;
                    ++ip;
                    break;
                }
                case 36: {
                    this.set_ins_read(ins, fb, ip);
                    ++ip;
                    break;
                }
                case 37: {
                    this.set_ins_read(ins, fb, ip);
                    ++ip;
                    break;
                }
                default: {
                    throw new Exception("next err code " + code + " " + types.OpCodeStr(code));
                }
            }
            ins.size = ip - ins.offset;
        }
    }

    private opt_ins get_assign_src_ins_from(int pos, long cmd) {
        for (int i = pos; i < this.inslist.size(); ++i) {
            opt_ins ins = this.inslist.get(i);
            if (ins.code != 0) continue;
            for (int j = 0; j < ins.src.size(); ++j) {
                if (ins.src.get((int)j).addr != cmd) continue;
                return ins;
            }
        }
        return null;
    }

    private opt_ins get_assign_dst_ins_from(int pos, long cmd) {
        for (int i = pos; i < this.inslist.size(); ++i) {
            opt_ins ins = this.inslist.get(i);
            if (ins.code != 0) continue;
            for (int j = 0; j < ins.dst.size(); ++j) {
                if (ins.dst.get((int)j).addr != cmd) continue;
                return ins;
            }
        }
        return null;
    }

    private opt_ins get_write_ins_from(int pos, long cmd) {
        for (int i = pos; i < this.inslist.size(); ++i) {
            opt_ins ins = this.inslist.get(i);
            for (int j = 0; j < ins.write.size(); ++j) {
                if (ins.write.get(j) != cmd) continue;
                return ins;
            }
        }
        return null;
    }

    private opt_ins get_read_ins_from(int pos, long cmd) {
        for (int i = pos; i < this.inslist.size(); ++i) {
            opt_ins ins = this.inslist.get(i);
            for (int j = 0; j < ins.read.size(); ++j) {
                if (ins.read.get(j) != cmd) continue;
                return ins;
            }
        }
        return null;
    }

    private void replace_ins_addr(func_binary fb, opt_ins_addr oldaddr, opt_ins_addr newaddr) {
        int offset = oldaddr.offset;
        fb.m_buff[offset] = newaddr.addr;
    }

    private void remove_ins(func_binary fb, opt_ins delins) {
        int i;
        block7: for (int i2 = 0; i2 < this.inslist.size(); ++i2) {
            opt_ins ins = this.inslist.get(i2);
            switch (ins.code) {
                case 16: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    int destip = command.COMMAND_CODE(fb.m_buff[ins.offset + 4]);
                    if (destip <= delins.offset) continue block7;
                    fb.m_buff[ins.offset + 4] = command.MAKE_POS(destip - delins.size);
                    continue block7;
                }
                case 34: {
                    int destip = command.COMMAND_CODE(fb.m_buff[ins.offset + 3]);
                    if (destip <= delins.offset) continue block7;
                    fb.m_buff[ins.offset + 3] = command.MAKE_POS(destip - delins.size);
                    continue block7;
                }
                case 13: {
                    int destip = command.COMMAND_CODE(fb.m_buff[ins.offset + 2]);
                    if (destip <= delins.offset) continue block7;
                    fb.m_buff[ins.offset + 2] = command.MAKE_POS(destip - delins.size);
                    continue block7;
                }
                case 14: {
                    int destip = command.COMMAND_CODE(fb.m_buff[ins.offset + 1]);
                    if (destip <= delins.offset) continue block7;
                    fb.m_buff[ins.offset + 1] = command.MAKE_POS(destip - delins.size);
                    continue block7;
                }
                case 15: {
                    int destip = command.COMMAND_CODE(fb.m_buff[ins.offset + 5]);
                    if (destip <= delins.offset) continue block7;
                    fb.m_buff[ins.offset + 5] = command.MAKE_POS(destip - delins.size);
                }
            }
        }
        long[] newbuff = new long[fb.m_buff.length - delins.size];
        int[] newlinenobuff = new int[fb.m_lineno_buff.length - delins.size];
        for (i = 0; i < delins.offset; ++i) {
            newbuff[i] = fb.m_buff[i];
            newlinenobuff[i] = fb.m_lineno_buff[i];
        }
        for (i = 0; i < fb.m_buff.length - delins.offset - delins.size; ++i) {
            newbuff[delins.offset + i] = fb.m_buff[delins.offset + delins.size + i];
            newlinenobuff[delins.offset + i] = fb.m_lineno_buff[delins.offset + delins.size + i];
        }
        fb.m_buff = newbuff;
        fb.m_lineno_buff = newlinenobuff;
    }

    private void optimize_assign_read(func_binary fb) {
        for (int i = 0; i < this.inslist.size(); ++i) {
            opt_ins ins = this.inslist.get(i);
            if (ins.code != 0) continue;
            opt_ins_addr src = ins.src.get(0);
            opt_ins_addr dst = ins.dst.get(0);
            if (command.ADDR_TYPE(command.COMMAND_CODE(src.addr)) == 2 || command.ADDR_TYPE(command.COMMAND_CODE(dst.addr)) == 2 || this.get_assign_dst_ins_from(0, dst.addr) != ins || this.get_assign_dst_ins_from(i + 1, dst.addr) != null || this.get_write_ins_from(0, dst.addr) != ins || this.get_write_ins_from(i + 1, dst.addr) != null) continue;
            for (int j = i + 1; j < this.inslist.size(); ++j) {
                opt_ins replaceins = this.inslist.get(j);
                for (int z = 0; z < replaceins.src.size(); ++z) {
                    opt_ins_addr replaceaddr = replaceins.src.get(z);
                    if (replaceaddr.addr != dst.addr) continue;
                    this.replace_ins_addr(fb, replaceaddr, src);
                }
            }
            this.remove_ins(fb, ins);
            this.isopt = true;
            return;
        }
    }

    private void optimize_write_write(func_binary fb) {
        for (int i = 0; i < this.inslist.size(); ++i) {
            opt_ins ins = this.inslist.get(i);
            if (ins.write.size() <= 0) continue;
            int num = 0;
            for (int j = 0; j < ins.write.size(); ++j) {
                opt_ins readins;
                long addr = ins.write.get(j);
                if (command.ADDR_TYPE(command.COMMAND_CODE(addr)) == 2 || ins.code == 35 || (readins = this.get_read_ins_from(0, addr)) != null) continue;
                ++num;
            }
            if (num != ins.write.size()) continue;
            this.remove_ins(fb, ins);
            this.isopt = true;
            return;
        }
    }

    private void optimize_write_assign(func_binary fb) {
        for (int i = 0; i < this.inslist.size(); ++i) {
            opt_ins ins = this.inslist.get(i);
            for (int j = 0; j < ins.dst.size(); ++j) {
                opt_ins assign_ins;
                opt_ins_addr addr = ins.dst.get(j);
                if (command.ADDR_TYPE(command.COMMAND_CODE(addr.addr)) == 2 || (assign_ins = this.get_assign_src_ins_from(i + 1, addr.addr)) == null || this.get_read_ins_from(i + 1, addr.addr) != assign_ins || this.get_read_ins_from(i + 2, addr.addr) != null) continue;
                opt_ins_addr assign_ins_addr = assign_ins.dst.get(0);
                this.replace_ins_addr(fb, addr, assign_ins_addr);
                this.remove_ins(fb, assign_ins);
                this.isopt = true;
                return;
            }
        }
        this.isopt = false;
    }
}

