/*
 * Decompiled with CFR 0.152.
 */
package com.github.esrrhs.fakescript;

import com.github.esrrhs.fakescript.fake;
import com.github.esrrhs.fakescript.routine;
import com.github.esrrhs.fakescript.variant;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class processor {
    private fake m_f;
    private routine m_entryroutine;
    private int m_genid;
    private routine m_curroutine;
    private ArrayList<routine> m_routines = new ArrayList();
    int m_lastroutine;
    int m_lastroutine_runnum;

    public processor(fake f) {
        this.m_f = f;
    }

    public routine get_curroutine() {
        return this.m_curroutine;
    }

    public routine get_entrycurroutine() {
        return this.m_entryroutine;
    }

    public routine start_routine(variant func, ArrayList<Integer> retpos) throws Exception {
        routine r = new routine(this.m_f);
        if (this.m_entryroutine == null) {
            this.m_entryroutine = r;
        }
        r.set_id(this.m_genid);
        ++this.m_genid;
        r.set_processor(this);
        r.entry(func, retpos);
        if (this.m_curroutine == null) {
            this.m_curroutine = r;
        }
        this.m_routines.add(r);
        return r;
    }

    public void run() throws Exception {
        block8: {
            block9: {
                if (!this.m_f.rn.is_stepmod()) break block9;
                if (this.m_routines.isEmpty()) {
                    return;
                }
                routine n = this.m_routines.get(this.m_lastroutine);
                n.run(1);
                ++this.m_lastroutine_runnum;
                boolean needupdate = false;
                if (n.is_end()) {
                    this.m_routines.remove(this.m_lastroutine);
                    needupdate = true;
                } else if (this.m_lastroutine_runnum >= this.m_f.cfg.per_frame_cmd_num) {
                    this.m_lastroutine_runnum = 0;
                    needupdate = true;
                }
                if (!needupdate) break block8;
                for (int i = 0; i < this.m_routines.size(); ++i) {
                    routine nex;
                    int index = this.m_lastroutine + i + 1;
                    if (index >= this.m_routines.size()) {
                        index %= this.m_routines.size();
                    }
                    if ((nex = this.m_routines.get(index)) == null) continue;
                    this.m_curroutine = n;
                    this.m_lastroutine = index;
                    break block8;
                }
                break block8;
            }
            while (!this.m_routines.isEmpty()) {
                for (int i = 0; i < this.m_routines.size(); ++i) {
                    routine r;
                    this.m_curroutine = r = this.m_routines.get(i);
                    r.run(this.m_f.cfg.per_frame_cmd_num);
                    if (!r.is_end()) continue;
                    this.m_routines.remove(i);
                }
            }
        }
    }

    public String get_routine_info() {
        String tmp = "";
        for (int i = 0; i < this.m_routines.size(); ++i) {
            routine r = this.m_routines.get(i);
            tmp = tmp + "#";
            tmp = tmp + i;
            tmp = tmp + "\tId:";
            tmp = tmp + r.get_id();
            tmp = tmp + "\t";
            tmp = tmp + r.get_interpreter().get_running_func_name();
            tmp = tmp + "(";
            tmp = tmp + r.get_interpreter().get_running_file_name();
            tmp = tmp + ":";
            tmp = tmp + r.get_interpreter().get_running_file_line();
            tmp = tmp + ")\t";
            tmp = tmp + (r.is_end() ? "Dead" : "Alive");
            tmp = tmp + "\n";
        }
        return tmp;
    }

    public routine get_routine_by_id(int id) {
        for (int i = 0; i < this.m_routines.size(); ++i) {
            routine r = this.m_routines.get(i);
            if (r == null || r.get_id() != id) continue;
            return r;
        }
        return null;
    }

    public String get_routine_info_by_id(int id) {
        int j = 0;
        for (int i = 0; i < this.m_routines.size(); ++i) {
            routine r = this.m_routines.get(i);
            if (r == null) continue;
            if (r.get_id() == id) {
                String ret = "";
                ret = ret + "#";
                ret = ret + j;
                ret = ret + "\tId:";
                ret = ret + id;
                ret = ret + "\t";
                ret = ret + r.get_interpreter().get_running_func_name();
                ret = ret + "(";
                ret = ret + r.get_interpreter().get_running_file_name();
                ret = ret + ":";
                ret = ret + r.get_interpreter().get_running_file_line();
                ret = ret + ")\t";
                ret = ret + (r.is_end() ? "Dead" : "Alive");
                ret = ret + "\n";
                return ret;
            }
            ++j;
        }
        return "";
    }

    public int get_routine_num() {
        return this.m_routines.size();
    }

    public routine get_routine_by_index(int index) {
        int j = 0;
        for (int i = 0; i < this.m_routines.size(); ++i) {
            routine r = this.m_routines.get(i);
            if (r == null) continue;
            if (j >= index) {
                return r;
            }
            ++j;
        }
        return null;
    }

    String get_routine_info_by_index(int index) {
        int j = 0;
        for (int i = 0; i < this.m_routines.size(); ++i) {
            routine r = this.m_routines.get(i);
            if (r == null) continue;
            if (j >= index) {
                return this.get_routine_info_by_id(r.get_id());
            }
            ++j;
        }
        return "";
    }
}

