/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.options.CreateTagsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateTagsOptionsTest {
    public void testCustomer() {
        CreateTagsOptions options = new CreateTagsOptions().customer("some-customer");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"some-customer"), (Collection)options.buildQueryParameters().get((Object)"customer"));
    }

    public void testCustomerStatic() {
        CreateTagsOptions options = CreateTagsOptions.Builder.customer((String)"some-customer");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"some-customer"), (Collection)options.buildQueryParameters().get((Object)"customer"));
    }

    public void testResourceIds() {
        CreateTagsOptions options = new CreateTagsOptions().resourceIds(new String[]{"1", "2", "3"});
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceIdsStatic() {
        CreateTagsOptions options = CreateTagsOptions.Builder.resourceIds((String[])new String[]{"1", "2", "3"});
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceIdsAsSet() {
        CreateTagsOptions options = new CreateTagsOptions().resourceIds((Set)ImmutableSet.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceIdsAsSetStatic() {
        CreateTagsOptions options = CreateTagsOptions.Builder.resourceIds((Set)ImmutableSet.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1,2,3"), (Collection)options.buildQueryParameters().get((Object)"resourceids"));
    }

    public void testResourceType() {
        CreateTagsOptions options = new CreateTagsOptions().resourceType(Tag.ResourceType.TEMPLATE);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testResourceTypeStatic() {
        CreateTagsOptions options = CreateTagsOptions.Builder.resourceType((Tag.ResourceType)Tag.ResourceType.TEMPLATE);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testResourceTypeAsString() {
        CreateTagsOptions options = new CreateTagsOptions().resourceType("Template");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testResourceTypeAsStringStatic() {
        CreateTagsOptions options = CreateTagsOptions.Builder.resourceType((String)"Template");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"Template"), (Collection)options.buildQueryParameters().get((Object)"resourcetype"));
    }

    public void testTags() {
        CreateTagsOptions options = new CreateTagsOptions().tags((Map)ImmutableMap.of((Object)"tag1", (Object)"val1", (Object)"tag2", (Object)"val2"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].value"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].value"));
    }

    public void testTagsStatic() {
        CreateTagsOptions options = CreateTagsOptions.Builder.tags((Map)ImmutableMap.of((Object)"tag1", (Object)"val1", (Object)"tag2", (Object)"val2"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].value"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].value"));
    }
}

