/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.VirtualMachineApi;
import org.jclouds.cloudstack.predicates.VirtualMachineDestroyed;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="VirtualMachineDestroyedTest")
public class VirtualMachineDestroyedTest {
    CloudStackApi client;
    VirtualMachineApi virtualMachineClient;

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        this.virtualMachineClient = (VirtualMachineApi)EasyMock.createMock(VirtualMachineApi.class);
        EasyMock.expect((Object)this.client.getVirtualMachineApi()).andReturn((Object)this.virtualMachineClient);
    }

    @Test
    public void testIsDestroyed() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id("229").state(VirtualMachine.State.DESTROYED).build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn((Object)virtualMachine);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertTrue((boolean)new VirtualMachineDestroyed(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }

    @Test
    public void testStillRunning() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id("229").state(VirtualMachine.State.RUNNING).build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn((Object)virtualMachine);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertFalse((boolean)new VirtualMachineDestroyed(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }
}

