/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.AccountApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccountApiExpectTest")
public class AccountApiExpectTest
extends BaseCloudStackExpectTest<AccountApi> {
    public void testListAccountsWhenResponseIs2xx() {
        AccountApi client = (AccountApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=listAccounts&listAll=true&apiKey=identity&signature=yMZYMZxzFlaUsbfxtuppMwNhpXI%3D").addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listaccountsresponse.json"))).build());
        ImmutableSet users = ImmutableSet.of((Object)User.builder().id("505").name("jclouds").firstName("Adrian").lastName("Cole").email("adrian@jclouds.org").created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-04-19T01:57:24+0000")).state(User.State.ENABLED).account("jclouds").accountType(Account.Type.USER).domainId("457").domain("AA000062-jclouds-dev").apiKey("APIKEY").secretKey("SECRETKEY").build());
        Assert.assertEquals((Set)client.listAccounts(new ListAccountsOptions[0]), (Set)ImmutableSet.of((Object)Account.builder().id("505").name("jclouds").type(Account.Type.USER).domainId("457").domain("AA000062-jclouds-dev").receivedBytes(318900216L).sentBytes(23189677L).VMLimit(Long.valueOf(15L)).VMs(1L).IPsAvailable(Long.valueOf(14L)).IPLimit(Long.valueOf(15L)).IPs(0L).IPsAvailable(Long.valueOf(15L)).volumeLimit(Long.valueOf(90L)).volumes(2L).volumesAvailable(Long.valueOf(88L)).snapshotLimit(Long.valueOf(250L)).snapshots(0L).snapshotsAvailable(Long.valueOf(250L)).templateLimit(Long.valueOf(15L)).templates(0L).templatesAvailable(Long.valueOf(15L)).VMsAvailable(Long.valueOf(14L)).VMsStopped(0L).VMsRunning(1L).state(Account.State.ENABLED).users((Set)users).build()));
    }

    @Override
    protected AccountApi clientFrom(CloudStackContext context) {
        return context.getApi().getAccountApi();
    }
}

