/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.jclouds.cloudstack.domain.JobResult;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.GenerateUsageRecordsOptions;
import org.jclouds.cloudstack.options.ListUsageRecordsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalUsageApiLiveTest")
public class GlobalUsageApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Test(groups={"live"}, enabled=true)
    public void testListUsage() {
        this.skipIfNotGlobalAdmin();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date end = c.getTime();
        c.add(2, -1);
        Date start = c.getTime();
        JobResult result = this.globalAdminClient.getUsageClient().generateUsageRecords(start, end, new GenerateUsageRecordsOptions[]{GenerateUsageRecordsOptions.NONE});
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccess(), (String)result.getDisplayText());
        Set records = this.globalAdminClient.getUsageClient().listUsageRecords(start, end, new ListUsageRecordsOptions[]{ListUsageRecordsOptions.NONE});
        Assert.assertNotNull((Object)records);
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
    }
}

