/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateFilter;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.cloudstack.features.TemplateApi;
import org.jclouds.cloudstack.internal.BaseCloudStackApiTest;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.CreateTemplateOptions;
import org.jclouds.cloudstack.options.DeleteTemplateOptions;
import org.jclouds.cloudstack.options.ExtractTemplateOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.RegisterTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplatePermissionsOptions;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TemplateApiTest")
public class TemplateApiTest
extends BaseCloudStackApiTest<TemplateApi> {
    HttpRequest registerTemplate = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"registerTemplate"}).addQueryParam("format", new String[]{"QCOW2"}).addQueryParam("hypervisor", new String[]{"xen"}).addQueryParam("url", new String[]{"http://example.com/"}).addQueryParam("zoneid", new String[]{"20"}).addQueryParam("name", new String[]{"thename"}).addQueryParam("ostypeid", new String[]{"10"}).addQueryParam("displaytext", new String[]{"description"}).build();
    HttpRequest registerTemplateOptions = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"registerTemplate"}).addQueryParam("format", new String[]{"QCOW2"}).addQueryParam("hypervisor", new String[]{"xen"}).addQueryParam("url", new String[]{"http://example.com/"}).addQueryParam("zoneid", new String[]{"20"}).addQueryParam("account", new String[]{"mydomain"}).addQueryParam("domainid", new String[]{"3"}).addQueryParam("bits", new String[]{"32"}).addQueryParam("checksum", new String[]{"ABC"}).addQueryParam("isextractable", new String[]{"true"}).addQueryParam("isfeatured", new String[]{"true"}).addQueryParam("ispublic", new String[]{"true"}).addQueryParam("passwordenabled", new String[]{"true"}).addQueryParam("requireshvm", new String[]{"true"}).addQueryParam("name", new String[]{"thename"}).addQueryParam("ostypeid", new String[]{"10"}).addQueryParam("displaytext", new String[]{"description"}).build();
    HttpRequest copyTemplate = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"copyTemplate"}).addQueryParam("id", new String[]{"17"}).addQueryParam("sourcezoneid", new String[]{"18"}).addQueryParam("destzoneid", new String[]{"19"}).build();
    HttpRequest extractTemplate = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"extractTemplate"}).addQueryParam("id", new String[]{"3"}).addQueryParam("mode", new String[]{"HTTP_DOWNLOAD"}).addQueryParam("zoneid", new String[]{"5"}).build();
    HttpRequest extractTemplateOptions = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"extractTemplate"}).addQueryParam("id", new String[]{"3"}).addQueryParam("mode", new String[]{"HTTP_DOWNLOAD"}).addQueryParam("zoneid", new String[]{"5"}).addQueryParam("url", new String[]{"http://example.com/"}).build();

    public void testCreateTemplate() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"createTemplate", (Class[])new Class[]{TemplateMetadata.class, CreateTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build()));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createTemplate&name=thename&ostypeid=10&displaytext=description HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateTemplateOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"createTemplate", (Class[])new Class[]{TemplateMetadata.class, CreateTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build(), (Object)CreateTemplateOptions.Builder.bits((int)32).isFeatured(true).isPublic(true).passwordEnabled(true).requiresHVM(true).snapshotId("11").volumeId("12")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=createTemplate&bits=32&isfeatured=true&ispublic=true&passwordenabled=true&requireshvm=true&snapshotid=11&volumeid=12&name=thename&ostypeid=10&displaytext=description HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRegisterTemplate() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"registerTemplate", (Class[])new Class[]{TemplateMetadata.class, String.class, String.class, String.class, String.class, RegisterTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build(), (Object)Template.Format.QCOW2, (Object)"xen", (Object)"http://example.com/", (Object)20));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.registerTemplate.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRegisterTemplateOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"registerTemplate", (Class[])new Class[]{TemplateMetadata.class, String.class, String.class, String.class, String.class, RegisterTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)TemplateMetadata.builder().name("thename").osTypeId("10").displayText("description").build(), (Object)Template.Format.QCOW2, (Object)"xen", (Object)"http://example.com/", (Object)20, (Object)RegisterTemplateOptions.Builder.accountInDomain((String)"mydomain", (String)"3").bits(32).checksum("ABC").isExtractable(true).isFeatured(true).isPublic(true).passwordEnabled(true).requiresHVM(true)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.registerTemplateOptions.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplate() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"updateTemplate", (Class[])new Class[]{String.class, UpdateTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplate&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplateOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"updateTemplate", (Class[])new Class[]{String.class, UpdateTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17, (Object)UpdateTemplateOptions.Builder.bootable((boolean)true).displayText("description").format(Template.Format.VHD).name("thename").osTypeId("12").passwordEnabled(true)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplate&id=17&bootable=true&displaytext=description&format=VHD&name=thename&ostypeid=12&passwordenabled=true HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCopyTemplate() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"copyTemplateToZone", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17, (Object)18, (Object)19));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.copyTemplate.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteTemplate() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"deleteTemplate", (Class[])new Class[]{String.class, DeleteTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteTemplate&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteTemplateOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"deleteTemplate", (Class[])new Class[]{String.class, DeleteTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17, (Object)DeleteTemplateOptions.Builder.zoneId((String)"8")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteTemplate&id=17&zoneid=8 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplates() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"listTemplates", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplates&listAll=true&templatefilter=executable HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplatesOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"listTemplates", (Class[])new Class[]{ListTemplatesOptions.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListTemplatesOptions.Builder.accountInDomain((String)"adrian", (String)"6").hypervisor("xen").filter(TemplateFilter.FEATURED)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplates&listAll=true&account=adrian&domainid=6&hypervisor=xen&templatefilter=featured HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetTemplate() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"getTemplateInZone", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)5, (Object)1));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplates&listAll=true&templatefilter=executable&id=5&zoneid=1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, Functions.compose((Function)IdentityFunction.INSTANCE, (Function)IdentityFunction.INSTANCE).getClass());
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplatePermissions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"updateTemplatePermissions", (Class[])new Class[]{String.class, UpdateTemplatePermissionsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplatePermissions&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateTemplatePermissionsOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"updateTemplatePermissions", (Class[])new Class[]{String.class, UpdateTemplatePermissionsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17, (Object)UpdateTemplatePermissionsOptions.Builder.accounts((Iterable)ImmutableSet.of((Object)"5", (Object)"6")).isExtractable(true).isFeatured(true).isPublic(true).op(UpdateTemplatePermissionsOptions.Operation.add)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=updateTemplatePermissions&id=17&accounts=5,6&isextractable=true&isfeatured=true&ispublic=true&op=add HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplatePermissions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"listTemplatePermissions", (Class[])new Class[]{String.class, AccountInDomainOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplatePermissions&listAll=true&id=17 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListTemplatePermissionsOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"listTemplatePermissions", (Class[])new Class[]{String.class, AccountInDomainOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)17, (Object)AccountInDomainOptions.Builder.accountInDomain((String)"fred", (String)"8")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listTemplatePermissions&listAll=true&id=17&account=fred&domainid=8 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testExtractTemplate() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"extractTemplate", (Class[])new Class[]{String.class, ExtractMode.class, String.class, ExtractTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)3, (Object)ExtractMode.HTTP_DOWNLOAD, (Object)5));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.extractTemplate.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testExtractTemplateOptions() throws NoSuchMethodException {
        Invokable method = Reflection2.method(TemplateApi.class, (String)"extractTemplate", (Class[])new Class[]{String.class, ExtractMode.class, String.class, ExtractTemplateOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)3, (Object)ExtractMode.HTTP_DOWNLOAD, (Object)5, (Object)ExtractTemplateOptions.Builder.url((String)"http://example.com/")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.extractTemplateOptions.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

