/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.Random;
import java.util.Set;
import org.jclouds.cloudstack.domain.VMGroup;
import org.jclouds.cloudstack.features.VMGroupApi;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateVMGroupOptions;
import org.jclouds.cloudstack.options.ListVMGroupsOptions;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="VMGroupApiLiveTest")
public class VMGroupApiLiveTest
extends BaseCloudStackApiLiveTest {
    private VMGroup groupCreated;

    public VMGroupApiLiveTest() {
        this.prefix = this.prefix + "2";
    }

    @Test
    public void testCreateListDestroyVMGroup() {
        VMGroupApi vmGroupClient = this.client.getVMGroupApi();
        String name = "jclouds-test-" + Integer.toHexString(new Random().nextInt());
        this.groupCreated = vmGroupClient.createInstanceGroup(name, new CreateVMGroupOptions[0]);
        Assert.assertEquals((String)this.groupCreated.getName(), (String)name);
        Set search = vmGroupClient.listInstanceGroups(new ListVMGroupsOptions[]{ListVMGroupsOptions.Builder.name((String)name)});
        Assert.assertEquals((int)1, (int)search.size());
        VMGroup groupFound = (VMGroup)Iterables.getOnlyElement((Iterable)search);
        Assert.assertEquals((Object)groupFound, (Object)this.groupCreated);
        vmGroupClient.deleteInstanceGroup(this.groupCreated.getId());
        this.groupCreated = null;
    }

    @AfterGroups(groups={"live"})
    protected void tearDownContext() {
        if (this.groupCreated != null) {
            this.client.getVMGroupApi().deleteInstanceGroup(this.groupCreated.getId());
        }
        super.tearDownContext();
    }
}

