/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.CloudStackApiMetadata;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.ApiKeyPair;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.options.ListAccountsOptions;

public class ApiKeyPairs {
    public static ApiKeyPair loginToEndpointAsUsernameInDomainWithPasswordAndReturnApiKeyPair(URI endpoint, String username, String password, String domain) {
        try (CloudStackContext context = null;){
            Properties overrides = new Properties();
            overrides.put("jclouds.trust-all-certs", "true");
            overrides.put("jclouds.relax-hostname", "true");
            overrides.put("jclouds.cloudstack.credential-type", "passwordCredentials");
            context = (CloudStackContext)ContextBuilder.newBuilder((ApiMetadata)new CloudStackApiMetadata()).endpoint(((URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint")).toASCIIString()).credentials(String.format("%s/%s", Preconditions.checkNotNull((Object)domain, (Object)"domain"), Preconditions.checkNotNull((Object)username, (Object)"username")), password).overrides(overrides).build(CloudStackContext.class);
            CloudStackApi client = context.getApi();
            Set<Account> listOfAccounts = client.getAccountApi().listAccounts(new ListAccountsOptions[0]);
            domain = domain.equals("") || domain.equals("/") ? "ROOT" : domain;
            for (Account account : listOfAccounts) {
                for (User user : account.getUsers()) {
                    if (!user.getName().equals(username) || !user.getDomain().equals(domain)) continue;
                    ApiKeyPair apiKeyPair = ((ApiKeyPair.Builder)((ApiKeyPair.Builder)ApiKeyPair.builder().apiKey(user.getApiKey())).secretKey(user.getSecretKey())).build();
                    return apiKeyPair;
                }
            }
            throw new NoSuchElementException("Unable to find API keypair for user " + username);
        }
    }
}

