/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.compute.functions.ServiceOfferingToHardwareTest;
import org.jclouds.cloudstack.compute.functions.TemplateToImageTest;
import org.jclouds.cloudstack.compute.functions.VirtualMachineToNodeMetadata;
import org.jclouds.cloudstack.compute.functions.ZoneToLocationTest;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.parse.ListVirtualMachinesResponseTest;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VirtualMachineToNodeMetadataTest")
public class VirtualMachineToNodeMetadataTest {
    GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(GroupNamingConvention.Factory.class);

    @Test
    public void testApplyWhereVirtualMachineWithIPForwardingRule() throws UnknownHostException {
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ZoneToLocationTest.one, (Object)ZoneToLocationTest.two));
        Supplier imageSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)TemplateToImageTest.one, (Object)TemplateToImageTest.two));
        VirtualMachineToNodeMetadata parser = new VirtualMachineToNodeMetadata(locationSupplier, imageSupplier, CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Set<IPForwardingRule>>(){

            public Set<IPForwardingRule> load(String arg0) throws Exception {
                return ImmutableSet.of((Object)IPForwardingRule.builder().id("1234l").IPAddress("1.1.1.1").build());
            }
        }), this.namingConvention);
        VirtualMachine guest = (VirtualMachine)Iterables.get((Iterable)new ListVirtualMachinesResponseTest().expected(), (int)0);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((String)node.toString(), (String)new NodeMetadataBuilder().id("54").providerId("54").name("i-3-54-VM").group("i-3-54").location(ZoneToLocationTest.one).status(NodeMetadata.Status.PENDING).hostname("i-3-54-VM").privateAddresses((Iterable)ImmutableSet.of((Object)"10.1.1.18")).publicAddresses((Iterable)ImmutableSet.of((Object)"1.1.1.1")).hardware(this.addHypervisor(ServiceOfferingToHardwareTest.one, "XenServer")).imageId(TemplateToImageTest.one.getId()).operatingSystem(TemplateToImageTest.one.getOperatingSystem()).tags((Iterable)ImmutableSet.of((Object)"another-tag")).userMetadata((Map)ImmutableMap.of((Object)"some-tag", (Object)"some-value")).build().toString());
    }

    @Test
    public void testApplyWhereVirtualMachineHasNoIpForwardingRuleAndAPublicIP() throws UnknownHostException {
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ZoneToLocationTest.one, (Object)ZoneToLocationTest.two));
        Supplier imageSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)TemplateToImageTest.one, (Object)TemplateToImageTest.two));
        VirtualMachineToNodeMetadata parser = new VirtualMachineToNodeMetadata(locationSupplier, imageSupplier, CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Set<IPForwardingRule>>(){

            public Set<IPForwardingRule> load(String arg0) throws Exception {
                return ImmutableSet.of();
            }
        }), this.namingConvention);
        VirtualMachine guest = VirtualMachine.builder().id("54").name("i-3-54-VM").displayName("i-3-54-VM").account("adrian").domainId("1").domain("ROOT").created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-02-16T14:28:37-0800")).state(VirtualMachine.State.STARTING).isHAEnabled(false).zoneId("1").zoneName("San Jose 1").templateId("2").templateName("CentOS 5.3(64-bit) no GUI (XenServer)").templateDisplayText("CentOS 5.3(64-bit) no GUI (XenServer)").passwordEnabled(false).serviceOfferingId("1").serviceOfferingName("Small Instance").cpuCount(1L).cpuSpeed(500L).memory(512L).guestOSId("11").rootDeviceId("0").rootDeviceType("NetworkFilesystem").jobId("63l").jobStatus(Integer.valueOf(0)).nics((Set)ImmutableSet.of((Object)NIC.builder().id("72").networkId("204").netmask("255.255.255.0").gateway("1.1.1.1").IPAddress("1.1.1.5").trafficType(TrafficType.GUEST).guestIPType(GuestIPType.VIRTUAL).isDefault(true).build())).hypervisor("XenServer").build();
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((String)node.toString(), (String)new NodeMetadataBuilder().id("54").providerId("54").name("i-3-54-VM").group("i-3-54").location(ZoneToLocationTest.one).status(NodeMetadata.Status.PENDING).hostname("i-3-54-VM").privateAddresses((Iterable)ImmutableSet.of()).publicAddresses((Iterable)ImmutableSet.of((Object)"1.1.1.5")).hardware(this.addHypervisor(ServiceOfferingToHardwareTest.one, "XenServer")).imageId(TemplateToImageTest.one.getId()).operatingSystem(TemplateToImageTest.one.getOperatingSystem()).build().toString());
    }

    @Test
    public void testApplyWhereVirtualMachineWithNoPassword() throws UnknownHostException {
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ZoneToLocationTest.one, (Object)ZoneToLocationTest.two));
        Supplier imageSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)TemplateToImageTest.one, (Object)TemplateToImageTest.two));
        VirtualMachineToNodeMetadata parser = new VirtualMachineToNodeMetadata(locationSupplier, imageSupplier, CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Set<IPForwardingRule>>(){

            public Set<IPForwardingRule> load(String arg0) throws Exception {
                throw new ResourceNotFoundException("no ip forwarding rule for: " + arg0);
            }
        }), this.namingConvention);
        VirtualMachine guest = (VirtualMachine)Iterables.get((Iterable)new ListVirtualMachinesResponseTest().expected(), (int)0);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((String)node.toString(), (String)new NodeMetadataBuilder().id("54").providerId("54").name("i-3-54-VM").group("i-3-54").location(ZoneToLocationTest.one).status(NodeMetadata.Status.PENDING).hostname("i-3-54-VM").privateAddresses((Iterable)ImmutableSet.of((Object)"10.1.1.18")).hardware(this.addHypervisor(ServiceOfferingToHardwareTest.one, "XenServer")).imageId(TemplateToImageTest.one.getId()).operatingSystem(TemplateToImageTest.one.getOperatingSystem()).tags((Iterable)ImmutableSet.of((Object)"another-tag")).userMetadata((Map)ImmutableMap.of((Object)"some-tag", (Object)"some-value")).build().toString());
    }

    protected Hardware addHypervisor(Hardware in, String hypervisor) {
        return HardwareBuilder.fromHardware((Hardware)in).hypervisor(hypervisor).build();
    }
}

