/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.strategy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.AdvancedNetworkOptionsConverter;
import org.jclouds.cloudstack.compute.strategy.BasicNetworkOptionsConverter;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkService;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="OptionsConverterTest")
public class OptionsConverterTest {
    private static final Map<String, Network> EMPTY_NETWORKS_MAP = ImmutableMap.of();
    private static final String ZONE_ID = "2";
    private final NetworkService firewallServiceWithStaticNat = NetworkService.builder().name("Firewall").capabilities((Map)ImmutableMap.of((Object)"StaticNat", (Object)"true")).build();

    @Test
    public void testBasicNetworkOptionsConverter() {
        BasicNetworkOptionsConverter converter = new BasicNetworkOptionsConverter();
        CloudStackTemplateOptions optionsIn = CloudStackTemplateOptions.Builder.securityGroupIds((Iterable)ImmutableList.of((Object)"42")).networks((Iterable)ImmutableList.of((Object)"46"));
        DeployVirtualMachineOptions optionsOut = new DeployVirtualMachineOptions();
        DeployVirtualMachineOptions optionsOut2 = converter.apply(optionsIn, EMPTY_NETWORKS_MAP, ZONE_ID, optionsOut);
        Assert.assertEquals((Object)optionsOut, (Object)optionsOut2);
        DeployVirtualMachineOptions optionsExpected = DeployVirtualMachineOptions.Builder.securityGroupId((String)"42").networkId("46");
        Assert.assertEquals((Object)optionsOut, (Object)optionsExpected);
    }

    @Test
    public void testAdvancedSecurityGroupsNotAllowed() {
        boolean exceptionThrown = false;
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        CloudStackTemplateOptions optionsIn = CloudStackTemplateOptions.Builder.securityGroupIds((Iterable)ImmutableList.of((Object)"42"));
        try {
            converter.apply(optionsIn, EMPTY_NETWORKS_MAP, ZONE_ID, DeployVirtualMachineOptions.NONE);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown, (String)"IllegalArgumentException should have been thrown");
    }

    @Test
    public void testAdvancedExplicitNetworkSelection() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        DeployVirtualMachineOptions optionsActual = converter.apply(new CloudStackTemplateOptions().networks((Iterable)ImmutableList.of((Object)"42")), EMPTY_NETWORKS_MAP, ZONE_ID, DeployVirtualMachineOptions.NONE);
        DeployVirtualMachineOptions optionsExpected = DeployVirtualMachineOptions.Builder.networkId((String)"42");
        Assert.assertEquals((Object)optionsActual, (Object)optionsExpected);
    }

    @Test
    public void testAdvancedAutoDetectNetwork() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        Network eligibleNetwork = Network.builder().id("25").zoneId(ZONE_ID).isDefault(true).services((Set)ImmutableSet.of((Object)this.firewallServiceWithStaticNat)).build();
        DeployVirtualMachineOptions optionsActual = converter.apply(new CloudStackTemplateOptions(), (Map)ImmutableMap.of((Object)eligibleNetwork.getId(), (Object)eligibleNetwork), ZONE_ID, DeployVirtualMachineOptions.NONE);
        DeployVirtualMachineOptions optionsExpected = DeployVirtualMachineOptions.Builder.networkId((String)"25");
        Assert.assertEquals((Object)optionsActual, (Object)optionsExpected);
    }

    @Test
    public void testAdvancedWhenNoNetworkGiven() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        boolean exceptionThrown = false;
        try {
            converter.apply(new CloudStackTemplateOptions(), EMPTY_NETWORKS_MAP, ZONE_ID, DeployVirtualMachineOptions.NONE);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testAdvancedWhenNoNetworkEligible() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        Network unsuitableNetwork = Network.builder().id("25").zoneId(ZONE_ID).build();
        boolean exceptionThrown = false;
        try {
            converter.apply(new CloudStackTemplateOptions(), (Map)ImmutableMap.of((Object)unsuitableNetwork.getId(), (Object)unsuitableNetwork), ZONE_ID, DeployVirtualMachineOptions.NONE);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }
}

