/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import org.jclouds.cloudstack.CloudStackGlobalApi;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateAccountOptions;
import org.jclouds.cloudstack.options.UpdateAccountOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalAccountApiLiveTest")
public class GlobalAccountApiLiveTest
extends BaseCloudStackApiLiveTest {
    public static Account createTestAccount(CloudStackGlobalApi client, String prefix) {
        return client.getAccountApi().createAccount(prefix + "-account", Account.Type.USER, "dummy@example.com", "First", "Last", BaseEncoding.base16().lowerCase().encode(Hashing.md5().hashString((CharSequence)"password", Charsets.UTF_8).asBytes()), new CreateAccountOptions[0]);
    }

    @Test
    public void testCreateAndRemoveAccount() {
        this.skipIfNotGlobalAdmin();
        Account account = null;
        try {
            account = GlobalAccountApiLiveTest.createTestAccount(this.globalAdminClient, this.prefix);
            Assert.assertNotNull((Object)account);
            Assert.assertEquals((String)account.getName(), (String)(this.prefix + "-account"));
            Assert.assertEquals((Object)account.getType(), (Object)Account.Type.USER);
            Account updated = this.globalAdminClient.getAccountApi().updateAccount(account.getName(), account.getDomainId(), this.prefix + "-account-2", new UpdateAccountOptions[0]);
            Assert.assertNotNull((Object)updated);
            Assert.assertEquals((String)updated.getName(), (String)(this.prefix + "-account-2"));
        }
        finally {
            if (account != null) {
                this.globalAdminClient.getAccountApi().deleteAccount(account.getId());
            }
        }
    }
}

