/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.Project;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.features.ProjectApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.ListProjectsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ProjectApiExpectTest")
public class ProjectApiExpectTest
extends BaseCloudStackExpectTest<ProjectApi> {
    public void testListProjectsWhenResponseIs2xx() {
        ProjectApi client = (ProjectApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api?response=json&command=listProjects&listAll=true&apiKey=identity&signature=vtCqaYXfXttr6mD18Es0e22QBIQ%3D").addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listprojectsresponse.json"))).build());
        ImmutableSet projects = ImmutableSet.of((Object)Project.builder().id("489da162-0b77-489d-b044-ce39aa018b1f").account("thyde").displayText("").domain("ROOT").domainId("41a4917b-7952-499d-ba7f-4c57464d3dc8").name("NN-HA-T1").state(Project.State.ACTIVE).build(), (Object)Project.builder().id("1c11f22c-15ac-4fa7-b833-4d748df317b7").account("prasadm").displayText("Hive").domain("ROOT").domainId("41a4917b-7952-499d-ba7f-4c57464d3dc8").name("hive").state(Project.State.ACTIVE).tags(new Tag[]{Tag.builder().account("prasadm").domain("ROOT").domainId("41a4917b-7952-499d-ba7f-4c57464d3dc8").key("some-tag").resourceId("1c11f22c-15ac-4fa7-b833-4d748df317b7").resourceType(Tag.ResourceType.PROJECT).value("some-value").build()}).build());
        Assert.assertEquals((Set)client.listProjects(new ListProjectsOptions[0]), (Set)projects);
    }

    @Override
    protected ProjectApi clientFrom(CloudStackContext context) {
        return context.getApi().getProjectApi();
    }
}

