/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListSSHKeyPairsOptions;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SSHKeyPairApiLiveTest")
public class SSHKeyPairApiLiveTest
extends BaseCloudStackApiLiveTest {
    protected String prefix = System.getProperty("user.name");
    private String keyPairName = this.prefix + "-jclouds-keypair";
    private SshKeyPair sshKeyPair;

    @BeforeMethod
    @AfterMethod
    public void removeExistingKey() {
        this.client.getSSHKeyPairApi().deleteSSHKeyPair(this.keyPairName);
    }

    @Test
    public void testListSSHKeyPairs() {
        Set sshKeyPairs = this.client.getSSHKeyPairApi().listSSHKeyPairs(new ListSSHKeyPairsOptions[0]);
        for (SshKeyPair sshKeyPair : sshKeyPairs) {
            this.checkSSHKeyPair(sshKeyPair);
        }
    }

    @Test
    public void testCreateDeleteSSHKeyPair() {
        this.sshKeyPair = this.client.getSSHKeyPairApi().createSSHKeyPair(this.keyPairName);
        Assert.assertNotNull((Object)this.sshKeyPair.getPrivateKey());
        this.checkSSHKeyPair(this.sshKeyPair);
        this.client.getSSHKeyPairApi().deleteSSHKeyPair(this.sshKeyPair.getName());
        Assert.assertEquals((Object)this.client.getSSHKeyPairApi().getSSHKeyPair(this.sshKeyPair.getName()), null);
        Assert.assertEquals((String)SshKeys.fingerprintPrivateKey((String)this.sshKeyPair.getPrivateKey()), (String)this.sshKeyPair.getFingerprint());
        this.sshKeyPair = null;
    }

    @Test
    public void testRegisterDeleteSSHKeyPair() {
        Map sshKey = SshKeys.generate();
        String publicKey = (String)sshKey.get("public");
        this.sshKeyPair = this.client.getSSHKeyPairApi().registerSSHKeyPair(this.keyPairName, publicKey);
        Assert.assertNull((Object)this.sshKeyPair.getPrivateKey());
        this.checkSSHKeyPair(this.sshKeyPair);
        this.client.getSSHKeyPairApi().deleteSSHKeyPair(this.keyPairName);
        Assert.assertEquals((Object)this.client.getSSHKeyPairApi().getSSHKeyPair(this.sshKeyPair.getName()), null);
        Assert.assertEquals((String)SshKeys.fingerprintPublicKey((String)publicKey), (String)this.sshKeyPair.getFingerprint());
        this.sshKeyPair = null;
    }

    protected void checkSSHKeyPair(SshKeyPair pair) {
        assert (pair.getName() != null) : pair;
        Assert.assertEquals((String)pair.getFingerprint(), (String)this.client.getSSHKeyPairApi().getSSHKeyPair(pair.getName()).getFingerprint());
    }
}

