/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.jclouds.cloudstack.domain.TemplateFilter;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListTemplatesOptionsTest {
    public void testId() {
        ListTemplatesOptions options = new ListTemplatesOptions().id("6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testIdStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.id((String)"6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testDomainId() {
        ListTemplatesOptions options = new ListTemplatesOptions().domainId("6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testDomainIdStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.domainId((String)"6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainId() {
        ListTemplatesOptions options = new ListTemplatesOptions().accountInDomain("adrian", "6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainIdStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.accountInDomain((String)"adrian", (String)"6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testHypervisor() {
        ListTemplatesOptions options = new ListTemplatesOptions().hypervisor("KVM");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"KVM"), (Collection)options.buildQueryParameters().get((Object)"hypervisor"));
    }

    public void testHypervisorStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.hypervisor((String)"KVM");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"KVM"), (Collection)options.buildQueryParameters().get((Object)"hypervisor"));
    }

    public void testName() {
        ListTemplatesOptions options = new ListTemplatesOptions().id("6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testNameStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.id((String)"6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testZoneId() {
        ListTemplatesOptions options = new ListTemplatesOptions().zoneId("6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testZoneIdStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.zoneId((String)"6");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testFilterDefault() {
        Assert.assertEquals((Collection)ImmutableList.of((Object)"executable"), (Collection)new ListTemplatesOptions().buildQueryParameters().get((Object)"templatefilter"));
    }

    public void testFilter() {
        ListTemplatesOptions options = new ListTemplatesOptions().filter(TemplateFilter.SELF_EXECUTABLE);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"self-executable"), (Collection)options.buildQueryParameters().get((Object)"templatefilter"));
    }

    public void testFilterStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.filter((TemplateFilter)TemplateFilter.SELF_EXECUTABLE);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"self-executable"), (Collection)options.buildQueryParameters().get((Object)"templatefilter"));
    }

    public void testTags() {
        ListTemplatesOptions options = new ListTemplatesOptions().tags((Map)ImmutableMap.of((Object)"tag1", (Object)"val1", (Object)"tag2", (Object)"val2"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].value"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].value"));
    }

    public void testTagsStatic() {
        ListTemplatesOptions options = ListTemplatesOptions.Builder.tags((Map)ImmutableMap.of((Object)"tag1", (Object)"val1", (Object)"tag2", (Object)"val2"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].key"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val1"), (Collection)options.buildQueryParameters().get((Object)"tags[0].value"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"val2"), (Collection)options.buildQueryParameters().get((Object)"tags[1].value"));
    }
}

