/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.IPForwardingRule;

@Singleton
public class GetIPForwardingRulesByVirtualMachine
extends CacheLoader<String, Set<IPForwardingRule>> {
    private final CloudStackApi client;

    @Inject
    public GetIPForwardingRulesByVirtualMachine(CloudStackApi client) {
        this.client = (CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public Set<IPForwardingRule> load(String input) {
        return this.client.getNATApi().getIPForwardingRulesForVirtualMachine(input);
    }
}

