/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindCIDRsToCommaDelimitedQueryParam
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Iterable), (Object)"this binder is only valid for Iterables!");
        Iterable cidrs = (Iterable)Preconditions.checkNotNull((Object)input, (Object)"cidr list");
        Preconditions.checkArgument((!Iterables.isEmpty((Iterable)cidrs) ? 1 : 0) != 0, (Object)"you must specify at least one cidr range");
        return (R)request.toBuilder().replaceQueryParam("cidrlist", new String[]{Joiner.on((char)',').join(cidrs)}).build();
    }
}

