/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class ClassnameFilter
implements Filter {
    public boolean isLoggable(LogRecord record) {
        String source;
        LogManager manager = LogManager.getLogManager();
        Level allowed = this.getLevel(manager, source = record.getSourceClassName());
        if (allowed == Level.OFF) {
            return false;
        }
        return allowed.intValue() <= record.getLevel().intValue();
    }

    Level getLevel(LogManager manager, String fqn) {
        String prop = fqn == null ? ".level" : fqn + ".level";
        String level = manager.getProperty(prop);
        if (level != null) {
            return Level.parse(level);
        }
        if (fqn == null || fqn.isEmpty()) {
            return Level.ALL;
        }
        int dollar = fqn.lastIndexOf("$");
        if (dollar > 0) {
            return this.getLevel(manager, fqn.substring(0, dollar));
        }
        int dot = fqn.lastIndexOf(".");
        if (dot <= 0) {
            return this.getLevel(manager, "");
        }
        return this.getLevel(manager, fqn.substring(0, dot));
    }
}

