/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.core;

import com.github.geko444.im4java.core.IMOperation;
import com.github.geko444.im4java.core.IdentifyCmd;
import com.github.geko444.im4java.core.InfoException;
import com.github.geko444.im4java.process.ArrayListOutputConsumer;
import com.github.geko444.im4java.process.Pipe;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class Info {
    private Hashtable<String, String> iAttributes = null;
    private LinkedList<Hashtable<String, String>> iAttribList = new LinkedList();
    private int iOldIndent = 0;
    private String iPrefix = "";

    public Info(String pImage) throws InfoException {
        this.getCompleteInfo(pImage, null);
    }

    public Info(String pImage, InputStream pInput) throws InfoException {
        if (pInput != null && !pImage.equals("-") && !pImage.endsWith(":-")) {
            throw new IllegalArgumentException("illegal filename for piped input");
        }
        this.getCompleteInfo(pImage, pInput);
    }

    public Info(String pImage, boolean basic) throws InfoException {
        if (!basic) {
            this.getCompleteInfo(pImage, null);
        } else {
            this.getBaseInfo(pImage, null);
        }
    }

    public Info(String pImage, InputStream pInput, boolean basic) throws InfoException {
        if (pInput != null && !pImage.equals("-") && !pImage.endsWith(":-")) {
            throw new IllegalArgumentException("illegal filename for piped input");
        }
        if (!basic) {
            this.getCompleteInfo(pImage, pInput);
        } else {
            this.getBaseInfo(pImage, pInput);
        }
    }

    private void getCompleteInfo(String pImage, InputStream pInput) throws InfoException {
        IMOperation op = new IMOperation();
        op.verbose();
        op.addImage(pImage);
        try {
            IdentifyCmd identify = new IdentifyCmd();
            ArrayListOutputConsumer output = new ArrayListOutputConsumer();
            identify.setOutputConsumer(output);
            if (pInput != null) {
                Pipe inputPipe = new Pipe(pInput, null);
                identify.setInputProvider(inputPipe);
            }
            identify.run(op, new Object[0]);
            ArrayList<String> cmdOutput = output.getOutput();
            StringBuilder lineAccu = new StringBuilder(80);
            for (String line : cmdOutput) {
                if (line.length() == 0) {
                    lineAccu.append("\n\n");
                    continue;
                }
                if (line.indexOf(58) == -1) {
                    lineAccu.append("\n").append(line);
                    continue;
                }
                if (lineAccu.length() > 0) {
                    this.parseLine(lineAccu.toString());
                    lineAccu = new StringBuilder(80);
                    lineAccu.append(line);
                    continue;
                }
                lineAccu.append(line);
            }
            if (lineAccu.length() > 0) {
                this.parseLine(lineAccu.toString());
            }
            this.addBaseInfo();
            this.iAttribList.add(this.iAttributes);
        }
        catch (Exception ex) {
            throw new InfoException(ex);
        }
    }

    private void addBaseInfo() {
        String[] dim;
        String geo = this.iAttributes.get("Geometry");
        if (geo != null) {
            dim = geo.split("x|\\+");
            this.iAttributes.put("Width", dim[0]);
            this.iAttributes.put("Height", dim[1]);
        }
        if ((geo = this.iAttributes.get("Page geometry")) != null) {
            dim = geo.split("x|\\+");
            this.iAttributes.put("PageWidth", dim[0]);
            this.iAttributes.put("PageHeight", dim[1]);
            this.iAttributes.put("PageGeometry", geo);
        }
    }

    private void parseLine(String pLine) {
        if (pLine.startsWith("Image:")) {
            if (this.iAttributes != null) {
                this.addBaseInfo();
                this.iAttribList.add(this.iAttributes);
            }
            this.iAttributes = new Hashtable();
        }
        int indent = pLine.indexOf(pLine.trim()) / 2;
        String[] parts = pLine.trim().split(": ", 2);
        if (indent < this.iOldIndent) {
            int colonIndex = this.iPrefix.length() - 1;
            for (int i = 0; i < this.iOldIndent - indent; ++i) {
                colonIndex = this.iPrefix.lastIndexOf(58, colonIndex - 1);
            }
            this.iPrefix = colonIndex == -1 ? "" : this.iPrefix.substring(0, colonIndex + 1);
        }
        this.iOldIndent = indent;
        if (parts.length == 1) {
            this.iPrefix = this.iPrefix + parts[0];
        } else {
            this.iAttributes.put(this.iPrefix + parts[0], parts[1]);
        }
    }

    private void getBaseInfo(String pImage, InputStream pInput) throws InfoException {
        IMOperation op = new IMOperation();
        op.ping();
        op.format("%m\n%w\n%h\n%g\n%W\n%H\n%G\n%z\n%r");
        op.addImage(pImage);
        try {
            IdentifyCmd identify = new IdentifyCmd();
            ArrayListOutputConsumer output = new ArrayListOutputConsumer();
            identify.setOutputConsumer(output);
            if (pInput != null) {
                Pipe inputPipe = new Pipe(pInput, null);
                identify.setInputProvider(inputPipe);
            }
            identify.run(op, new Object[0]);
            ArrayList<String> cmdOutput = output.getOutput();
            Iterator<String> iter = cmdOutput.iterator();
            this.iAttributes = new Hashtable();
            this.iAttributes.put("Format", iter.next());
            this.iAttributes.put("Width", iter.next());
            this.iAttributes.put("Height", iter.next());
            this.iAttributes.put("Geometry", iter.next());
            this.iAttributes.put("PageWidth", iter.next());
            this.iAttributes.put("PageHeight", iter.next());
            this.iAttributes.put("PageGeometry", iter.next());
            this.iAttributes.put("Depth", iter.next());
            this.iAttributes.put("Class", iter.next());
            this.iAttribList.add(this.iAttributes);
        }
        catch (Exception ex) {
            throw new InfoException(ex);
        }
    }

    public String getImageFormat() {
        return this.iAttributes.get("Format");
    }

    public String getImageFormat(int pSceneNr) {
        return this.iAttribList.get(pSceneNr).get("Format");
    }

    public int getImageWidth() throws InfoException {
        return this.getImageWidth(this.iAttribList.size() - 1);
    }

    public int getImageWidth(int pSceneNr) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(pSceneNr).get("Width"));
        }
        catch (NumberFormatException ex) {
            throw new InfoException(ex);
        }
    }

    public int getImageHeight() throws InfoException {
        return this.getImageHeight(this.iAttribList.size() - 1);
    }

    public int getImageHeight(int pSceneNr) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(pSceneNr).get("Height"));
        }
        catch (NumberFormatException ex) {
            throw new InfoException(ex);
        }
    }

    public String getImageGeometry() {
        return this.iAttributes.get("Geometry");
    }

    public String getImageGeometry(int pSceneNr) {
        return this.iAttribList.get(pSceneNr).get("Geometry");
    }

    public int getImageDepth() throws InfoException {
        return this.getImageDepth(this.iAttribList.size() - 1);
    }

    public int getImageDepth(int pSceneNr) throws InfoException {
        String[] depth = this.iAttribList.get(pSceneNr).get("Depth").split("-|/", 2);
        try {
            return Integer.parseInt(depth[0]);
        }
        catch (NumberFormatException ex) {
            throw new InfoException(ex);
        }
    }

    public String getImageClass() {
        return this.iAttributes.get("Class");
    }

    public String getImageClass(int pSceneNr) {
        return this.iAttribList.get(pSceneNr).get("Class");
    }

    public int getPageWidth() throws InfoException {
        return this.getPageWidth(this.iAttribList.size() - 1);
    }

    public int getPageWidth(int pSceneNr) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(pSceneNr).get("PageWidth"));
        }
        catch (NumberFormatException ex) {
            throw new InfoException(ex);
        }
    }

    public int getPageHeight() throws InfoException {
        return this.getPageHeight(this.iAttribList.size() - 1);
    }

    public int getPageHeight(int pSceneNr) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(pSceneNr).get("PageHeight"));
        }
        catch (NumberFormatException ex) {
            throw new InfoException(ex);
        }
    }

    public String getPageGeometry() {
        return this.iAttributes.get("PageGeometry");
    }

    public String getPageGeometry(int pSceneNr) {
        return this.iAttribList.get(pSceneNr).get("PageGeometry");
    }

    public String getProperty(String pPropertyName) {
        return this.iAttributes.get(pPropertyName);
    }

    public String getProperty(String pPropertyName, int pSceneNr) {
        return this.iAttribList.get(pSceneNr).get(pPropertyName);
    }

    public int getSceneCount() {
        return this.iAttribList.size();
    }

    public Enumeration<String> getPropertyNames() {
        return this.iAttributes.keys();
    }
}

