/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.core;

import com.github.geko444.im4java.core.DynamicOperation;
import java.util.LinkedList;
import java.util.List;

public class Operation {
    public static final String IMG_PLACEHOLDER = "?img?";
    static final String DOP_PLACEHOLDER = "?dop?";
    LinkedList<String> iCmdArgs = new LinkedList();
    private LinkedList<DynamicOperation> iDynamicOperations = new LinkedList();

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (String arg : this.iCmdArgs) {
            buf.append(arg).append(" ");
        }
        return buf.toString();
    }

    public Operation cloneObject() {
        Operation op = new Operation();
        op.getCmdArgs().addAll(this.iCmdArgs);
        return op;
    }

    public Operation addRawArgs(String ... pArgs) {
        for (String arg : pArgs) {
            this.iCmdArgs.add(arg);
        }
        return this;
    }

    public Operation addRawArgs(List<String> pArgs) {
        this.iCmdArgs.addAll(pArgs);
        return this;
    }

    public LinkedList<String> getCmdArgs() {
        return this.iCmdArgs;
    }

    public Operation addImage(String ... pImages) {
        for (String img : pImages) {
            if (img == null) continue;
            if (img.charAt(0) == '[' && img.charAt(img.length() - 1) == ']') {
                this.iCmdArgs.add(IMG_PLACEHOLDER + img);
                continue;
            }
            this.iCmdArgs.add(img);
        }
        return this;
    }

    public Operation addImage() {
        return this.addImage(1);
    }

    public Operation addImage(int n) {
        for (int i = 0; i < n; ++i) {
            this.iCmdArgs.add(IMG_PLACEHOLDER);
        }
        return this;
    }

    public Operation addOperation(Operation pOperation) {
        return this.addRawArgs(pOperation.getCmdArgs());
    }

    public Operation addDynamicOperation(DynamicOperation pOperation) {
        this.iDynamicOperations.add(pOperation);
        this.iCmdArgs.add(DOP_PLACEHOLDER);
        return this;
    }

    public LinkedList<DynamicOperation> getDynamicOperations() {
        return this.iDynamicOperations;
    }
}

