/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.process;

import com.github.geko444.im4java.process.ProcessEvent;
import com.github.geko444.im4java.process.ProcessEventListener;
import com.github.geko444.im4java.process.ProcessTask;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ProcessExecutor
extends ThreadPoolExecutor
implements ProcessEventListener {
    private Set<Process> iProcesses = new LinkedHashSet<Process>();
    private boolean iShutdownNowInProgress = false;

    public ProcessExecutor() {
        this(ProcessExecutor.getDefaultPoolSize());
    }

    public ProcessExecutor(int pProcs) {
        super(pProcs, pProcs, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.prestartAllCoreThreads();
    }

    private static int getDefaultPoolSize() {
        String maxProcs = System.getProperty("im4java.maxProcs");
        int nProcs = maxProcs == null || maxProcs.equals("auto") ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(maxProcs);
        return Math.max(1, nProcs);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.iShutdownNowInProgress) {
            t.stop();
            try {
                super.beforeExecute(t, r);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (r instanceof ProcessTask) {
            ProcessTask pt = (ProcessTask)r;
            pt.getProcessStarter().addProcessEventListener(this);
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (r instanceof ProcessTask) {
            ProcessTask pt = (ProcessTask)r;
            pt.getProcessStarter().removeProcessEventListener(this);
        }
    }

    @Override
    public void processInitiated(ProcessEvent pEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStarted(ProcessEvent pEvent) {
        Set<Process> set = this.iProcesses;
        synchronized (set) {
            this.iProcesses.add(pEvent.getProcess());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTerminated(ProcessEvent pEvent) {
        Set<Process> set = this.iProcesses;
        synchronized (set) {
            this.iProcesses.remove(pEvent.getProcess());
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.iShutdownNowInProgress = true;
        this.destroy();
        return super.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Set<Process> set = this.iProcesses;
        synchronized (set) {
            Iterator<Process> it = this.iProcesses.iterator();
            while (it.hasNext()) {
                it.next().destroy();
            }
        }
    }
}

