/*
 * Decompiled with CFR 0.152.
 */
package com.github.geko444.im4java.test;

import com.github.geko444.im4java.core.ConvertCmd;
import com.github.geko444.im4java.core.DisplayCmd;
import com.github.geko444.im4java.core.IMOperation;
import com.github.geko444.im4java.core.ImageCommand;
import com.github.geko444.im4java.process.Pipe;
import com.github.geko444.im4java.process.ProcessEvent;
import com.github.geko444.im4java.process.ProcessEventListener;
import com.github.geko444.im4java.process.ProcessTask;
import com.github.geko444.im4java.test.AbstractTestCase;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TestCase23
extends AbstractTestCase
implements ProcessEventListener {
    private ConvertCmd iCmd1;
    private ConvertCmd iCmd2;
    private IMOperation iOp1;
    private IMOperation iOp2;
    private PipedInputStream iPis;
    private PipedOutputStream iPos;

    @Override
    public String getDescription() {
        return "chaining of commands";
    }

    public static void main(String[] args) {
        TestCase23 tc = new TestCase23();
        tc.runTest(args);
    }

    @Override
    public void run() throws Exception {
        int rc;
        System.err.println("23. Testing chaining of commands ...");
        String syncType = "sync1";
        if (this.iArgs != null && this.iArgs.length > 0) {
            syncType = this.iArgs[0];
        }
        int induceError = 0;
        if (this.iArgs != null && this.iArgs.length > 1) {
            induceError = Integer.parseInt(this.iArgs[1]);
        }
        this.iPis = new PipedInputStream();
        this.iPos = new PipedOutputStream(this.iPis);
        Pipe pipeOut = new Pipe(null, this.iPos);
        Pipe pipeIn = new Pipe(this.iPis, null);
        this.iOp1 = new IMOperation();
        this.iOp1.addImage(iImageDir + "ipomoea.jpg");
        this.iOp1.resize((Integer)200, null, Character.valueOf('%'));
        if (induceError == 1) {
            this.iOp1.rotate();
        }
        this.iOp1.addImage("tif:-");
        this.iCmd1 = new ConvertCmd();
        this.iCmd1.setOutputConsumer(pipeOut);
        this.iCmd1.addProcessEventListener(this);
        this.iOp2 = new IMOperation();
        this.iOp2.addImage("tif:-");
        this.iOp2.rotate(90.0);
        if (induceError == 2) {
            this.iOp2.resize();
        }
        this.iOp2.addImage(iImageDir + "ipomoea-large.jpg");
        this.iCmd2 = new ConvertCmd();
        this.iCmd2.setInputProvider(pipeIn);
        if (syncType.equals("sync1")) {
            rc = this.sync1();
        } else if (syncType.equals("sync2")) {
            rc = this.sync2();
        } else {
            System.err.println("error: illegal sync-type");
            rc = 1;
        }
        if (rc == 0) {
            DisplayCmd.show(iImageDir + "ipomoea-large.jpg");
        }
    }

    private int sync1() throws Exception {
        this.iCmd2.setAsyncMode(true);
        ProcessTask pt = this.iCmd2.getProcessTask(this.iOp2, new Object[0]);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(pt);
        exec.shutdown();
        try {
            this.iCmd1.run(this.iOp1, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.iPos.close();
            this.iPis.close();
        }
        int rc = ((ProcessEvent)pt.get()).getReturnCode();
        if (rc > 0) {
            System.err.println("Problem with cmd2. Trying to shutdown execution...");
            pt.cancel(true);
            exec.shutdownNow();
            System.err.println("process cmd2 terminated");
        }
        return rc;
    }

    private int sync2() throws Exception {
        this.iCmd1.setAsyncMode(true);
        ProcessTask pt = this.iCmd1.getProcessTask(this.iOp1, new Object[0]);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(pt);
        exec.shutdown();
        this.iCmd2.run(this.iOp2, new Object[0]);
        int rc = ((ProcessEvent)pt.get()).getReturnCode();
        if (rc > 0) {
            System.err.println("Problem with cmd1. Trying to shutdown execution...");
            pt.cancel(true);
            exec.shutdownNow();
            System.err.println("process cmd1 terminated");
        }
        return rc;
    }

    @Override
    public void processInitiated(ProcessEvent pEvent) {
    }

    @Override
    public void processStarted(ProcessEvent pEvent) {
    }

    @Override
    public void processTerminated(ProcessEvent pEvent) {
        if (pEvent.getReturnCode() != 0) {
            System.err.println("problem with cmd1");
            ImageCommand cmd = (ImageCommand)pEvent.getProcessStarter();
            ArrayList<String> errors = cmd.getErrorText();
            if (errors != null && errors.size() > 0) {
                System.err.println("  printing errors:");
                for (String err : errors) {
                    System.err.println("  " + err);
                }
            }
            try {
                this.iPos.close();
                this.iPis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

