/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.manager.impl;

import io.api.etherscan.manager.IQueueManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class QueueManager
implements IQueueManager,
AutoCloseable {
    public static final QueueManager DEFAULT_KEY_QUEUE = new QueueManager(1, 7);
    public static final QueueManager PERSONAL_KEY_QUEUE = new QueueManager(5, 1100L, 1100L, 5);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final Semaphore semaphore;
    private final long queueResetTimeInMillis;

    public QueueManager(int size, int resetInSec) {
        this(size, resetInSec, resetInSec);
    }

    public QueueManager(int size, int queueResetTimeInSec, int delayInSec) {
        this(size, queueResetTimeInSec, delayInSec, size);
    }

    public QueueManager(int size, int queueResetTimeInSec, int delayInSec, int initialSize) {
        this(size, (long)queueResetTimeInSec * 1000L, (long)delayInSec * 1000L, initialSize);
    }

    public QueueManager(int size, long queueResetTimeInMillis, long delayInMillis, int initialSize) {
        this.queueResetTimeInMillis = queueResetTimeInMillis;
        this.semaphore = new Semaphore(initialSize);
        this.executorService.scheduleAtFixedRate(this.releaseLocks(size), delayInMillis, queueResetTimeInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void takeTurn() {
        try {
            this.semaphore.tryAcquire(this.queueResetTimeInMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Runnable releaseLocks(int toRelease) {
        return () -> this.semaphore.release(toRelease);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

