/*
 * Decompiled with CFR 0.152.
 */
package com.github.greengerong;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;

public class PreRenderSEOFilter
implements Filter {
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            ResponseResult result;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if (this.shouldShowPrerenderedPage(request) && (result = this.getPrerenderedPageResponse(request)).getStatusCode() == 200) {
                PrintWriter writer = servletResponse.getWriter();
                writer.write(result.getResponseBody());
                writer.flush();
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private ResponseResult getPrerenderedPageResponse(HttpServletRequest request) throws IOException {
        String apiUrl = this.getApiUrl(this.getFullUrl(request));
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(apiUrl);
        this.setConfig(httpClient);
        this.setHttpHeader((HttpMethod)getMethod);
        int code = httpClient.executeMethod((HttpMethod)getMethod);
        String responseBody = getMethod.getResponseBodyAsString();
        String body = new String(responseBody.getBytes("utf-8"));
        return new ResponseResult(code, body);
    }

    private String getFullUrl(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append('?');
            url.append(queryString);
        }
        return url.toString();
    }

    private void setHttpHeader(HttpMethod httpMethod) {
        httpMethod.setRequestHeader("Cache-Control", "no-cache");
        httpMethod.setRequestHeader("Content-Type", "text/html");
    }

    private void setConfig(HttpClient httpClient) {
        String proxy = this.filterConfig.getInitParameter("proxy");
        if (StringUtils.isNotBlank((String)proxy)) {
            int proxyPort = Integer.parseInt(this.filterConfig.getInitParameter("proxyPort"));
            httpClient.getHostConfiguration().setProxy(proxy, proxyPort);
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private List<String> getCrawlerUserAgents() {
        ArrayList crawlerUserAgents = Lists.newArrayList((Object[])new String[]{"googlebot", "yahoo", "bingbot", "baiduspider", "facebookexternalhit", "twitterbot"});
        String crawlerUserAgentsFromConfig = this.filterConfig.getInitParameter("crawlerUserAgents");
        if (StringUtils.isNotBlank((String)crawlerUserAgentsFromConfig)) {
            crawlerUserAgents.addAll(Arrays.asList(crawlerUserAgentsFromConfig.trim().split(",")));
        }
        return crawlerUserAgents;
    }

    private List<String> getExtensionsToIgnore() {
        ArrayList extensionsToIgnore = Lists.newArrayList((Object[])new String[]{".js", ".css", ".less", ".png", ".jpg", ".jpeg", ".gif", ".pdf", ".doc", ".txt", ".zip", ".mp3", ".rar", ".exe", ".wmv", ".doc", ".avi", ".ppt", ".mpg", ".mpeg", ".tif", ".wav", ".mov", ".psd", ".ai", ".xls", ".mp4", ".m4a", ".swf", ".dat", ".dmg", ".iso", ".flv", ".m4v", ".torrent"});
        String extensionsToIgnoreFromConfig = this.filterConfig.getInitParameter("extensionsToIgnore");
        if (StringUtils.isNotBlank((String)extensionsToIgnoreFromConfig)) {
            extensionsToIgnore.addAll(Arrays.asList(extensionsToIgnoreFromConfig.trim().split(",")));
        }
        return extensionsToIgnore;
    }

    private List<String> getWhitelist() {
        String whitelist = this.filterConfig.getInitParameter("whitelist");
        if (StringUtils.isNotBlank((String)whitelist)) {
            return Arrays.asList(whitelist.trim().split(","));
        }
        return null;
    }

    private List<String> getBlacklist() {
        String blacklist = this.filterConfig.getInitParameter("blacklist");
        if (StringUtils.isNotBlank((String)blacklist)) {
            return Arrays.asList(blacklist.trim().split(","));
        }
        return null;
    }

    private boolean shouldShowPrerenderedPage(HttpServletRequest request) throws URISyntaxException {
        String useAgent = request.getHeader("User-Agent");
        String url = request.getRequestURL().toString();
        String referer = request.getHeader("Referer");
        if (this.hasEscapedFragment(request)) {
            return true;
        }
        if (StringUtils.isBlank((String)useAgent)) {
            return false;
        }
        if (!this.isInSearchUserAgent(useAgent)) {
            return false;
        }
        if (this.isInResources(url)) {
            return false;
        }
        List<String> whiteList = this.getWhitelist();
        if (whiteList != null && !this.isInWhiteList(url, whiteList)) {
            return false;
        }
        List<String> blacklist = this.getBlacklist();
        return blacklist == null || !this.isInBlackList(url, referer, blacklist);
    }

    private boolean hasEscapedFragment(HttpServletRequest request) {
        return request.getParameterMap().containsKey("_escaped_fragment_");
    }

    private String getApiUrl(String url) {
        String prerenderServiceUrl = this.getPrerenderServiceUrl();
        if (!prerenderServiceUrl.endsWith("/")) {
            prerenderServiceUrl = prerenderServiceUrl + "/";
        }
        return prerenderServiceUrl + url;
    }

    private String getPrerenderServiceUrl() {
        String prerenderServiceUrl = this.filterConfig.getInitParameter("prerenderServiceUrl");
        return StringUtils.isNotBlank((String)prerenderServiceUrl) ? prerenderServiceUrl : "http://prerender.herokuapp.com/";
    }

    private boolean isInBlackList(final String url, final String referer, List<String> blacklist) {
        return FluentIterable.from(blacklist).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String regex) {
                Pattern pattern = Pattern.compile(regex);
                return pattern.matcher(url).matches() || !StringUtils.isBlank((String)referer) && pattern.matcher(referer).matches();
            }
        });
    }

    private boolean isInWhiteList(final String url, List<String> whitelist) {
        return FluentIterable.from(whitelist).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String regex) {
                return Pattern.compile(regex).matcher(url).matches();
            }
        });
    }

    private boolean isInResources(final String url) {
        return FluentIterable.from(this.getExtensionsToIgnore()).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String item) {
                return url.contains(item.toLowerCase());
            }
        });
    }

    private boolean isInSearchUserAgent(final String useAgent) {
        return FluentIterable.from(this.getCrawlerUserAgents()).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String item) {
                return item.equalsIgnoreCase(useAgent);
            }
        });
    }

    private class ResponseResult {
        private int statusCode;
        private String responseBody;

        public ResponseResult(int code, String body) {
            this.statusCode = code;
            this.responseBody = body;
        }

        private int getStatusCode() {
            return this.statusCode;
        }

        private String getResponseBody() {
            return this.responseBody;
        }
    }
}

