/*
 * Decompiled with CFR 0.152.
 */
package com.github.hekonsek.rxjava.view.document.memory;

import com.github.hekonsek.rxjava.view.document.DocumentView;
import com.github.hekonsek.rxjava.view.document.DocumentWithKey;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InMemoryDocumentView
implements DocumentView {
    private final Map<String, Map<String, Map<String, Object>>> documents = new LinkedHashMap<String, Map<String, Map<String, Object>>>();

    public synchronized Completable save(String collection, String key, Map<String, Object> document) {
        Map collectionData = this.documents.computeIfAbsent(collection, k -> new LinkedHashMap());
        collectionData.put(key, document);
        return Completable.complete();
    }

    public synchronized Single<Map<String, Object>> findById(String collection, String key) {
        Map collectionData = this.documents.computeIfAbsent(collection, k -> new LinkedHashMap());
        return Single.just(collectionData.get(key));
    }

    public synchronized Single<Long> count(String collection) {
        Map collectionData = this.documents.computeIfAbsent(collection, key -> new LinkedHashMap());
        return Single.just((Object)collectionData.size());
    }

    public synchronized Observable<DocumentWithKey> findAll(String collection) {
        List documentsWithIds = this.documents.computeIfAbsent(collection, key -> new LinkedHashMap()).entrySet().stream().map(entry -> new DocumentWithKey((String)entry.getKey(), (Map)entry.getValue())).collect(Collectors.toList());
        return Observable.fromIterable(documentsWithIds);
    }

    public synchronized Completable remove(String collection, String key) {
        Map collectionData = this.documents.computeIfAbsent(collection, k -> new LinkedHashMap());
        collectionData.remove(key);
        return Completable.complete();
    }
}

