/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import java.util.Arrays;

public enum Scale {
    UNITS(1.0),
    TENTHS(0.1),
    HUNDREDTHS(0.01),
    THOUSANDTHS(0.001),
    TEN_THOUSANDTHS(1.0E-4),
    HUNDRED_THOUSANDTHS(1.0E-5),
    MILLIONTHS(1.0E-6),
    TEN_MILLIONTHS(1.0E-7),
    HUNDRED_MILLIONTHS(1.0E-8),
    TENS(10.0),
    HUNDREDS(100.0),
    THOUSANDS(1000.0),
    TEN_THOUSANDS(10000.0),
    HUNDRED_THOUSANDS(100000.0),
    MILLIONS(1000000.0),
    TEN_MILLIONS(1.0E7),
    HUNDRED_MILLIONS(1.0E8);

    private static final Scale[] NEGATIVE_SCALES;
    private static final Scale[] POSITIVE_SCALES;
    public static final double[] NEGATIVE_SCALE_DECIMALS;
    public static final double[] POSITIVE_SCALE_DECIMALS;
    public static final double HALF = 0.5;
    private final double decimal;
    private final int scale;

    private Scale(double aDecimal) {
        this.decimal = aDecimal;
        this.scale = -((int)Math.log10(aDecimal));
    }

    public final double calculateUnscaledValue(double aValue) {
        double unscaledValue = aValue / this.decimal + 0.5;
        return unscaledValue >= -2.147483648E9 && unscaledValue <= 2.147483647E9 ? unscaledValue : Double.NaN;
    }

    public final double calculateDoubleFromUnscaledValue(long aValue) {
        return (double)aValue * this.decimal;
    }

    public final int getScale() {
        return this.scale;
    }

    public final double getDecimal() {
        return this.decimal;
    }

    public static Scale valueOf(int aScale) {
        try {
            return aScale >= 0 ? POSITIVE_SCALES[aScale] : NEGATIVE_SCALES[-aScale];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Precision not found with scale=" + aScale + " in " + Arrays.asList(Scale.values()), e);
        }
    }

    public static final Scale valueOf(double aDecimal) {
        for (Scale scale : Scale.values()) {
            if (aDecimal != scale.decimal) continue;
            return scale;
        }
        throw new IllegalArgumentException("Precision not found with decimal=" + aDecimal + " in " + Arrays.asList(Scale.values()));
    }

    static {
        int maxScale = 0;
        int minScale = 0;
        for (Scale precision : Scale.values()) {
            if (precision.getScale() > maxScale) {
                maxScale = precision.getScale();
            }
            if (precision.getScale() >= minScale) continue;
            minScale = precision.getScale();
        }
        NEGATIVE_SCALES = new Scale[-minScale + 1];
        POSITIVE_SCALES = new Scale[maxScale + 1];
        NEGATIVE_SCALE_DECIMALS = new double[-minScale + 1];
        POSITIVE_SCALE_DECIMALS = new double[maxScale + 1];
        for (Scale scale : Scale.values()) {
            if (scale.getScale() >= 0) {
                Scale.POSITIVE_SCALES[scale.getScale()] = scale;
                Scale.POSITIVE_SCALE_DECIMALS[scale.getScale()] = scale.getDecimal();
                continue;
            }
            Scale.NEGATIVE_SCALES[-scale.getScale()] = scale;
            Scale.NEGATIVE_SCALE_DECIMALS[-scale.getScale()] = scale.getDecimal();
        }
    }
}

