/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import com.github.hermod.ser.Msg;
import java.math.BigDecimal;
import java.util.Arrays;

public enum Type {
    NULL(0),
    SKIPPED_KEYS_TYPE(0),
    INTEGER(64),
    DECIMAL(96),
    STRING_UTF8(-128),
    MSG(-96),
    ARRAY_FIXED_VALUE(-64),
    ARRAY_VARIABLE_VALUE(-32);

    private final byte id;

    private Type(byte aId) {
        this.id = aId;
    }

    public final byte getId() {
        return this.id;
    }

    public final byte getShiftId() {
        return (byte)(this.id >> 5);
    }

    public static Type valueOf(byte aId) {
        for (Type type : Type.values()) {
            if (type.getId() != aId) continue;
            return type;
        }
        throw new IllegalArgumentException("The type with id=" + aId + " not found in EType.values()=" + Arrays.asList(Type.values()));
    }

    public static <T> Type valueOf(Class<T> clazz) {
        if (Integer.class.equals(clazz) || Long.class.equals(clazz) || Short.class.equals(clazz) || Byte.class.equals(clazz) || Boolean.class.equals(clazz)) {
            return INTEGER;
        }
        if (Double.class.equals(clazz) || Float.class.equals(clazz) || BigDecimal.class.equals(clazz)) {
            return DECIMAL;
        }
        if (String.class.equals(clazz)) {
            return STRING_UTF8;
        }
        if (Msg.class.equals(clazz)) {
            return MSG;
        }
        if (int[].class.equals(clazz) || long[].class.equals(clazz) || short[].class.equals(clazz) || byte[].class.equals(clazz) || boolean[].class.equals(clazz) || double[].class.equals(clazz) || float[].class.equals(clazz)) {
            return ARRAY_FIXED_VALUE;
        }
        if (Integer[].class.equals(clazz) || Long[].class.equals(clazz) || Short[].class.equals(clazz) || Byte[].class.equals(clazz) || Boolean[].class.equals(clazz) || Double[].class.equals(clazz) || Float[].class.equals(clazz) || String[].class.equals(clazz) || Msg[].class.equals(clazz)) {
            return ARRAY_VARIABLE_VALUE;
        }
        throw new IllegalArgumentException("The type with class=" + clazz + " not found in EType.values()=" + Arrays.asList(Type.values()));
    }
}

