/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfpmDataField;
import com.hframe.domain.model.HfpmDataField_Example;
import com.hframe.service.interfaces.IHfpmDataFieldSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.beans.exceptions.BusinessException;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfpmDataField"})
public class HfpmDataFieldController {
    private static final Logger logger = LoggerFactory.getLogger(HfpmDataFieldController.class);
    @Resource
    private IHfpmDataFieldSV iHfpmDataFieldSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfpmDataField") HfpmDataField hfpmDataField, @ModelAttribute(value="example") HfpmDataField_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfpmDataField, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfpmDataField, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfpmDataField> list = this.iHfpmDataFieldSV.getHfpmDataFieldListByExample(example);
            pagination.setTotalCount(this.iHfpmDataFieldSV.getHfpmDataFieldCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfpmDataField") HfpmDataField hfpmDataField) {
        logger.debug("request : {},{}", (Object)hfpmDataField.getHfpmDataFieldId(), (Object)hfpmDataField);
        try {
            HfpmDataField result = null;
            if (hfpmDataField.getHfpmDataFieldId() != null) {
                result = this.iHfpmDataFieldSV.getHfpmDataFieldByPK(hfpmDataField.getHfpmDataFieldId());
            } else {
                HfpmDataField_Example example = (HfpmDataField_Example)ExampleUtils.parseExample((Object)hfpmDataField, HfpmDataField_Example.class);
                List<HfpmDataField> list = this.iHfpmDataFieldSV.getHfpmDataFieldListByExample(example);
                if (list != null && list.size() == 1) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value=" hfpmDataField") HfpmDataField hfpmDataField) {
        logger.debug("request : {}", (Object)hfpmDataField);
        try {
            HfpmDataField result = null;
            if (hfpmDataField.getHfpmDataFieldId() != null) {
                result = this.iHfpmDataFieldSV.getHfpmDataFieldByPK(hfpmDataField.getHfpmDataFieldId());
            } else {
                HfpmDataField_Example example = (HfpmDataField_Example)ExampleUtils.parseExample((Object)hfpmDataField, HfpmDataField_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfpmDataField> list = this.iHfpmDataFieldSV.getHfpmDataFieldListByExample(example);
                if (list != null && list.size() > 0) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfpmDataField") HfpmDataField hfpmDataField) {
        logger.debug("request : {}", (Object)hfpmDataField);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmDataField, (String)"hfpmDataFieldId");
            int result = this.iHfpmDataFieldSV.create(hfpmDataField);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataField);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfpmDataField[] hfpmDataFields) {
        logger.debug("request : {}", (Object[])hfpmDataFields);
        try {
            ControllerHelper.setDefaultValue((Object[])hfpmDataFields, (String)"hfpmDataFieldId");
            ControllerHelper.reorderProperty((Object[])hfpmDataFields);
            int result = this.iHfpmDataFieldSV.batchOperate(hfpmDataFields);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataFields);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfpmDataField") HfpmDataField hfpmDataField) {
        logger.debug("request : {}", (Object)hfpmDataField);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmDataField, (String)"hfpmDataFieldId");
            int result = this.iHfpmDataFieldSV.update(hfpmDataField);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataField);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/saveOrUpdateByAjax.json"})
    @ResponseBody
    public ResultData saveOrUpdate(@ModelAttribute(value="hfpmDataField") HfpmDataField hfpmDataField) {
        logger.debug("request : {}", (Object)hfpmDataField);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmDataField, (String)"hfpmDataFieldId");
            int result = this.iHfpmDataFieldSV.batchOperate(new HfpmDataField[]{hfpmDataField});
            if (result > 0) {
                return ResultData.success((Object)hfpmDataField);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfpmDataField") HfpmDataField hfpmDataField) {
        logger.debug("request : {}", (Object)hfpmDataField);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmDataField, (String)"hfpmDataFieldId");
            int result = this.iHfpmDataFieldSV.delete(hfpmDataField);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataField);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfpmDataFieldSV getIHfpmDataFieldSV() {
        return this.iHfpmDataFieldSV;
    }

    public void setIHfpmDataFieldSV(IHfpmDataFieldSV iHfpmDataFieldSV) {
        this.iHfpmDataFieldSV = iHfpmDataFieldSV;
    }
}

