/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfsecRole;
import com.hframe.domain.model.HfsecRole_Example;
import com.hframe.service.interfaces.IHfsecRoleSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.beans.exceptions.BusinessException;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfsecRole"})
public class HfsecRoleController {
    private static final Logger logger = LoggerFactory.getLogger(HfsecRoleController.class);
    @Resource
    private IHfsecRoleSV iHfsecRoleSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfsecRole") HfsecRole hfsecRole, @ModelAttribute(value="example") HfsecRole_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfsecRole, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfsecRole, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfsecRole> list = this.iHfsecRoleSV.getHfsecRoleListByExample(example);
            pagination.setTotalCount(this.iHfsecRoleSV.getHfsecRoleCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfsecRole") HfsecRole hfsecRole) {
        logger.debug("request : {},{}", (Object)hfsecRole.getHfsecRoleId(), (Object)hfsecRole);
        try {
            HfsecRole result = null;
            if (hfsecRole.getHfsecRoleId() != null) {
                result = this.iHfsecRoleSV.getHfsecRoleByPK(hfsecRole.getHfsecRoleId());
            } else {
                HfsecRole_Example example = (HfsecRole_Example)ExampleUtils.parseExample((Object)hfsecRole, HfsecRole_Example.class);
                List<HfsecRole> list = this.iHfsecRoleSV.getHfsecRoleListByExample(example);
                if (list != null && list.size() == 1) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value=" hfsecRole") HfsecRole hfsecRole) {
        logger.debug("request : {}", (Object)hfsecRole);
        try {
            HfsecRole result = null;
            if (hfsecRole.getHfsecRoleId() != null) {
                result = this.iHfsecRoleSV.getHfsecRoleByPK(hfsecRole.getHfsecRoleId());
            } else {
                HfsecRole_Example example = (HfsecRole_Example)ExampleUtils.parseExample((Object)hfsecRole, HfsecRole_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfsecRole> list = this.iHfsecRoleSV.getHfsecRoleListByExample(example);
                if (list != null && list.size() > 0) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfsecRole") HfsecRole hfsecRole) {
        logger.debug("request : {}", (Object)hfsecRole);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecRole, (String)"hfsecRoleId");
            int result = this.iHfsecRoleSV.create(hfsecRole);
            if (result > 0) {
                return ResultData.success((Object)hfsecRole);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfsecRole[] hfsecRoles) {
        logger.debug("request : {}", (Object[])hfsecRoles);
        try {
            ControllerHelper.setDefaultValue((Object[])hfsecRoles, (String)"hfsecRoleId");
            ControllerHelper.reorderProperty((Object[])hfsecRoles);
            int result = this.iHfsecRoleSV.batchOperate(hfsecRoles);
            if (result > 0) {
                return ResultData.success((Object)hfsecRoles);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfsecRole") HfsecRole hfsecRole) {
        logger.debug("request : {}", (Object)hfsecRole);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecRole, (String)"hfsecRoleId");
            int result = this.iHfsecRoleSV.update(hfsecRole);
            if (result > 0) {
                return ResultData.success((Object)hfsecRole);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/saveOrUpdateByAjax.json"})
    @ResponseBody
    public ResultData saveOrUpdate(@ModelAttribute(value="hfsecRole") HfsecRole hfsecRole) {
        logger.debug("request : {}", (Object)hfsecRole);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecRole, (String)"hfsecRoleId");
            int result = this.iHfsecRoleSV.batchOperate(new HfsecRole[]{hfsecRole});
            if (result > 0) {
                return ResultData.success((Object)hfsecRole);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfsecRole") HfsecRole hfsecRole) {
        logger.debug("request : {}", (Object)hfsecRole);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecRole, (String)"hfsecRoleId");
            int result = this.iHfsecRoleSV.delete(hfsecRole);
            if (result > 0) {
                return ResultData.success((Object)hfsecRole);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfsecRoleSV getIHfsecRoleSV() {
        return this.iHfsecRoleSV;
    }

    public void setIHfsecRoleSV(IHfsecRoleSV iHfsecRoleSV) {
        this.iHfsecRoleSV = iHfsecRoleSV;
    }
}

