/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.service.impl;

import com.google.common.collect.Lists;
import com.hframe.dao.HfsecOrganizeMapper;
import com.hframe.domain.model.HfsecOrganize;
import com.hframe.domain.model.HfsecOrganize_Example;
import com.hframe.service.interfaces.IHfsecOrganizeSV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="iHfsecOrganizeSV")
public class HfsecOrganizeSVImpl
implements IHfsecOrganizeSV {
    @Resource
    private HfsecOrganizeMapper hfsecOrganizeMapper;

    @Override
    public int create(HfsecOrganize hfsecOrganize) throws Exception {
        return this.hfsecOrganizeMapper.insertSelective(hfsecOrganize);
    }

    @Override
    public int batchOperate(HfsecOrganize[] hfsecOrganizes) throws Exception {
        int result = 0;
        if (hfsecOrganizes != null) {
            for (HfsecOrganize hfsecOrganize : hfsecOrganizes) {
                if (hfsecOrganize.getHfsecOrganizeId() == null) {
                    result += this.create(hfsecOrganize);
                    continue;
                }
                result += this.update(hfsecOrganize);
            }
        }
        return result;
    }

    @Override
    public int update(HfsecOrganize hfsecOrganize) throws Exception {
        return this.hfsecOrganizeMapper.updateByPrimaryKeySelective(hfsecOrganize);
    }

    @Override
    public int updateByExample(HfsecOrganize hfsecOrganize, HfsecOrganize_Example example) throws Exception {
        return this.hfsecOrganizeMapper.updateByExampleSelective(hfsecOrganize, example);
    }

    @Override
    public int delete(HfsecOrganize hfsecOrganize) throws Exception {
        return this.hfsecOrganizeMapper.deleteByPrimaryKey(hfsecOrganize.getHfsecOrganizeId());
    }

    @Override
    public int delete(long hfsecOrganizeId) throws Exception {
        return this.hfsecOrganizeMapper.deleteByPrimaryKey(hfsecOrganizeId);
    }

    @Override
    public List<HfsecOrganize> getHfsecOrganizeAll() throws Exception {
        return this.hfsecOrganizeMapper.selectByExample(new HfsecOrganize_Example());
    }

    @Override
    public HfsecOrganize getHfsecOrganizeByPK(long hfsecOrganizeId) throws Exception {
        return this.hfsecOrganizeMapper.selectByPrimaryKey(hfsecOrganizeId);
    }

    @Override
    public Map<Long, List<HfsecOrganize>> getHfsecOrganizeTreeByParentId(HfsecOrganize hfsecOrganize, HfsecOrganize_Example example) throws Exception {
        HashMap<Long, List<HfsecOrganize>> result = new HashMap<Long, List<HfsecOrganize>>();
        this.fillHfsecOrganizeTreeCascade(result, Lists.newArrayList((Object[])new Long[]{hfsecOrganize.getParentHfsecOrganizeId() == null ? -1L : hfsecOrganize.getParentHfsecOrganizeId()}), example);
        return result;
    }

    private void fillHfsecOrganizeTreeCascade(Map<Long, List<HfsecOrganize>> result, List<Long> parentIds, HfsecOrganize_Example example) {
        if (parentIds.size() == 0) {
            return;
        }
        if (example == null) {
            example = new HfsecOrganize_Example();
        }
        if (example.getOredCriteria() == null || example.getOredCriteria().size() == 0) {
            example.createCriteria();
        }
        example.getOredCriteria().get(0).andParentHfsecOrganizeIdIn((List)parentIds);
        List<HfsecOrganize> hfsecOrganizes = this.hfsecOrganizeMapper.selectByExample(example);
        if (hfsecOrganizes == null || hfsecOrganizes.size() == 0) {
            return;
        }
        if (parentIds.size() == 1) {
            result.put(parentIds.get(0), hfsecOrganizes);
        } else {
            for (HfsecOrganize hfsecOrganize : hfsecOrganizes) {
                Long parentId = hfsecOrganize.getParentHfsecOrganizeId();
                if (!result.containsKey(parentId)) {
                    result.put(parentId, new ArrayList());
                }
                result.get(parentId).add(hfsecOrganize);
            }
        }
        ArrayList<Long> subIds = new ArrayList<Long>();
        for (HfsecOrganize hfsecOrganize : hfsecOrganizes) {
            subIds.add(hfsecOrganize.getHfsecOrganizeId());
        }
        this.fillHfsecOrganizeTreeCascade(result, subIds, null);
    }

    @Override
    public List<HfsecOrganize> getHfsecOrganizeListByParam(Map<String, Object> params) throws Exception {
        return null;
    }

    @Override
    public List<HfsecOrganize> getHfsecOrganizeListByExample(HfsecOrganize_Example example) throws Exception {
        return this.hfsecOrganizeMapper.selectByExample(example);
    }

    @Override
    public int getHfsecOrganizeCountByParam(Map<String, Object> params) throws Exception {
        return 0;
    }

    @Override
    public int getHfsecOrganizeCountByExample(HfsecOrganize_Example example) throws Exception {
        return this.hfsecOrganizeMapper.countByExample(example);
    }

    public HfsecOrganizeMapper getHfsecOrganizeMapper() {
        return this.hfsecOrganizeMapper;
    }

    public void setHfsecOrganizeMapper(HfsecOrganizeMapper hfsecOrganizeMapper) {
        this.hfsecOrganizeMapper = hfsecOrganizeMapper;
    }
}

