/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfmdEntityRel;
import com.hframe.domain.model.HfmdEntityRel_Example;
import com.hframe.service.interfaces.IHfmdEntityRelSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfmdEntityRel"})
public class HfmdEntityRelController {
    private static final Logger logger = LoggerFactory.getLogger(HfmdEntityRelController.class);
    @Resource
    private IHfmdEntityRelSV iHfmdEntityRelSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfmdEntityRel") HfmdEntityRel hfmdEntityRel, @ModelAttribute(value="example") HfmdEntityRel_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfmdEntityRel, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfmdEntityRel, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfmdEntityRel> list = this.iHfmdEntityRelSV.getHfmdEntityRelListByExample(example);
            pagination.setTotalCount(this.iHfmdEntityRelSV.getHfmdEntityRelCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfmdEntityRel") HfmdEntityRel hfmdEntityRel) {
        logger.debug("request : {},{}", (Object)hfmdEntityRel.getHfmdEntityRelId(), (Object)hfmdEntityRel);
        try {
            HfmdEntityRel result = this.iHfmdEntityRelSV.getHfmdEntityRelByPK(hfmdEntityRel.getHfmdEntityRelId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfmdEntityRel") HfmdEntityRel hfmdEntityRel) {
        logger.debug("request : {}", (Object)hfmdEntityRel);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntityRel, (String)"hfmdEntityRelId");
            int result = this.iHfmdEntityRelSV.create(hfmdEntityRel);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityRel);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfmdEntityRel[] hfmdEntityRels) {
        logger.debug("request : {}", (Object[])hfmdEntityRels);
        try {
            ControllerHelper.setDefaultValue((Object[])hfmdEntityRels, (String)"hfmdEntityRelId");
            ControllerHelper.reorderProperty((Object[])hfmdEntityRels);
            int result = this.iHfmdEntityRelSV.batchOperate(hfmdEntityRels);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityRels);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfmdEntityRel") HfmdEntityRel hfmdEntityRel) {
        logger.debug("request : {}", (Object)hfmdEntityRel);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntityRel, (String)"hfmdEntityRelId");
            int result = this.iHfmdEntityRelSV.update(hfmdEntityRel);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityRel);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfmdEntityRel") HfmdEntityRel hfmdEntityRel) {
        logger.debug("request : {}", (Object)hfmdEntityRel);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntityRel, (String)"hfmdEntityRelId");
            int result = this.iHfmdEntityRelSV.delete(hfmdEntityRel);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityRel);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfmdEntityRelSV getIHfmdEntityRelSV() {
        return this.iHfmdEntityRelSV;
    }

    public void setIHfmdEntityRelSV(IHfmdEntityRelSV iHfmdEntityRelSV) {
        this.iHfmdEntityRelSV = iHfmdEntityRelSV;
    }
}

