/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfsecMenu;
import com.hframe.domain.model.HfsecMenu_Example;
import com.hframe.service.interfaces.IHfsecMenuSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfsecMenu"})
public class HfsecMenuController {
    private static final Logger logger = LoggerFactory.getLogger(HfsecMenuController.class);
    @Resource
    private IHfsecMenuSV iHfsecMenuSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfsecMenu") HfsecMenu hfsecMenu, @ModelAttribute(value="example") HfsecMenu_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfsecMenu, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfsecMenu, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfsecMenu> list = this.iHfsecMenuSV.getHfsecMenuListByExample(example);
            pagination.setTotalCount(this.iHfsecMenuSV.getHfsecMenuCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryTeeByAjax.json"})
    @ResponseBody
    public ResultData tree(@ModelAttribute(value="hfsecMenu") HfsecMenu hfsecMenu, @ModelAttribute(value="example") HfsecMenu_Example example) {
        logger.debug("request : {},{}", (Object)hfsecMenu, (Object)example);
        try {
            ExampleUtils.parseExample((Object)hfsecMenu, (Object)example);
            Map<Long, List<HfsecMenu>> treeMap = this.iHfsecMenuSV.getHfsecMenuTreeByParentId(hfsecMenu, example);
            return ResultData.success(treeMap);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value="hfsecMenu") HfsecMenu hfsecMenu) {
        logger.debug("request : {},{}", (Object)hfsecMenu.getHfsecMenuId(), (Object)hfsecMenu);
        try {
            HfsecMenu result = null;
            if (hfsecMenu.getHfsecMenuId() != null) {
                result = this.iHfsecMenuSV.getHfsecMenuByPK(hfsecMenu.getHfsecMenuId());
            } else {
                HfsecMenu_Example example = (HfsecMenu_Example)ExampleUtils.parseExample((Object)hfsecMenu, HfsecMenu_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfsecMenu> hfsecMenuListByExample = this.iHfsecMenuSV.getHfsecMenuListByExample(example);
                if (hfsecMenuListByExample != null && hfsecMenuListByExample.size() > 0) {
                    result = hfsecMenuListByExample.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfsecMenu") HfsecMenu hfsecMenu) {
        logger.debug("request : {},{}", (Object)hfsecMenu.getHfsecMenuId(), (Object)hfsecMenu);
        try {
            HfsecMenu result = null;
            if (hfsecMenu.getHfsecMenuId() != null) {
                result = this.iHfsecMenuSV.getHfsecMenuByPK(hfsecMenu.getHfsecMenuId());
            } else {
                HfsecMenu_Example example = (HfsecMenu_Example)ExampleUtils.parseExample((Object)hfsecMenu, HfsecMenu_Example.class);
                List<HfsecMenu> list = this.iHfsecMenuSV.getHfsecMenuListByExample(example);
                if (list != null && list.size() == 1) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfsecMenu") HfsecMenu hfsecMenu) {
        logger.debug("request : {}", (Object)hfsecMenu);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecMenu, (String)"hfsecMenuId");
            int result = this.iHfsecMenuSV.create(hfsecMenu);
            if (result > 0) {
                return ResultData.success((Object)hfsecMenu);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfsecMenu[] hfsecMenus) {
        logger.debug("request : {}", (Object[])hfsecMenus);
        try {
            ControllerHelper.setDefaultValue((Object[])hfsecMenus, (String)"hfsecMenuId");
            ControllerHelper.reorderProperty((Object[])hfsecMenus);
            int result = this.iHfsecMenuSV.batchOperate(hfsecMenus);
            if (result > 0) {
                return ResultData.success((Object)hfsecMenus);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfsecMenu") HfsecMenu hfsecMenu) {
        logger.debug("request : {}", (Object)hfsecMenu);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecMenu, (String)"hfsecMenuId");
            int result = this.iHfsecMenuSV.update(hfsecMenu);
            if (result > 0) {
                return ResultData.success((Object)hfsecMenu);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfsecMenu") HfsecMenu hfsecMenu) {
        logger.debug("request : {}", (Object)hfsecMenu);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecMenu, (String)"hfsecMenuId");
            int result = this.iHfsecMenuSV.delete(hfsecMenu);
            if (result > 0) {
                return ResultData.success((Object)hfsecMenu);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfsecMenuSV getIHfsecMenuSV() {
        return this.iHfsecMenuSV;
    }

    public void setIHfsecMenuSV(IHfsecMenuSV iHfsecMenuSV) {
        this.iHfsecMenuSV = iHfsecMenuSV;
    }
}

