/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfusWordStore;
import com.hframe.domain.model.HfusWordStore_Example;
import com.hframe.service.interfaces.IHfusWordStoreSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfusWordStore"})
public class HfusWordStoreController {
    private static final Logger logger = LoggerFactory.getLogger(HfusWordStoreController.class);
    @Resource
    private IHfusWordStoreSV iHfusWordStoreSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfusWordStore") HfusWordStore hfusWordStore, @ModelAttribute(value="example") HfusWordStore_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfusWordStore, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfusWordStore, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfusWordStore> list = this.iHfusWordStoreSV.getHfusWordStoreListByExample(example);
            pagination.setTotalCount(this.iHfusWordStoreSV.getHfusWordStoreCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfusWordStore") HfusWordStore hfusWordStore) {
        logger.debug("request : {},{}", (Object)hfusWordStore.getHfusWordStoreId(), (Object)hfusWordStore);
        try {
            HfusWordStore result = this.iHfusWordStoreSV.getHfusWordStoreByPK(hfusWordStore.getHfusWordStoreId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfusWordStore") HfusWordStore hfusWordStore) {
        logger.debug("request : {}", (Object)hfusWordStore);
        try {
            ControllerHelper.setDefaultValue((Object)hfusWordStore, (String)"hfusWordStoreId");
            int result = this.iHfusWordStoreSV.create(hfusWordStore);
            if (result > 0) {
                return ResultData.success((Object)hfusWordStore);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfusWordStore[] hfusWordStores) {
        logger.debug("request : {}", (Object[])hfusWordStores);
        try {
            ControllerHelper.setDefaultValue((Object[])hfusWordStores, (String)"hfusWordStoreId");
            ControllerHelper.reorderProperty((Object[])hfusWordStores);
            int result = this.iHfusWordStoreSV.batchOperate(hfusWordStores);
            if (result > 0) {
                return ResultData.success((Object)hfusWordStores);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfusWordStore") HfusWordStore hfusWordStore) {
        logger.debug("request : {}", (Object)hfusWordStore);
        try {
            ControllerHelper.setDefaultValue((Object)hfusWordStore, (String)"hfusWordStoreId");
            int result = this.iHfusWordStoreSV.update(hfusWordStore);
            if (result > 0) {
                return ResultData.success((Object)hfusWordStore);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfusWordStore") HfusWordStore hfusWordStore) {
        logger.debug("request : {}", (Object)hfusWordStore);
        try {
            ControllerHelper.setDefaultValue((Object)hfusWordStore, (String)"hfusWordStoreId");
            int result = this.iHfusWordStoreSV.delete(hfusWordStore);
            if (result > 0) {
                return ResultData.success((Object)hfusWordStore);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfusWordStoreSV getIHfusWordStoreSV() {
        return this.iHfusWordStoreSV;
    }

    public void setIHfusWordStoreSV(IHfusWordStoreSV iHfusWordStoreSV) {
        this.iHfusWordStoreSV = iHfusWordStoreSV;
    }
}

