package com.github.houbb.monitor.client.java.bs;

import com.github.houbb.id.api.Id;
import com.github.houbb.id.core.core.Ids;
import com.github.houbb.monitor.client.java.core.MonitorClient;

/**
 * 引导类
 * @since 1.0.0
 * @author dh
 */
public final class MonitorClientBs {

    private MonitorClientBs(){}

    /**
     * 系统标识
     */
    private String systemId = "test";

    /**
     * 服务地址
     */
    private String serverAddress = "http://127.0.0.1:8080/monitor-server/";

    /**
     * 密码盐值
     */
    private String saltKey = "";

    /**
     * 日志跟踪号生成策略
     */
    private Id traceIdGenerator = Ids.uuid32();

    /**
     * 环境标识
     */
    private String envId = "test";

    /**
     * 最大批次
     */
    private int maxBatchSize = 1000;

    /**
     * 初始化延迟秒数
     * @since 1.0.0
     */
    private long initDelaySeconds  = 10;

    /**
     * 重复调度秒数
     * @since 1.0.0
     */
    private long periodSeconds = 10;

    public static MonitorClientBs newInstance() {
        return new MonitorClientBs();
    }

    public String systemId() {
        return systemId;
    }

    public MonitorClientBs systemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public String serverAddress() {
        return serverAddress;
    }

    public MonitorClientBs serverAddress(String serverAddress) {
        this.serverAddress = serverAddress;
        return this;
    }

    public String saltKey() {
        return saltKey;
    }

    public MonitorClientBs saltKey(String saltKey) {
        this.saltKey = saltKey;
        return this;
    }

    public Id traceIdGenerator() {
        return traceIdGenerator;
    }

    public MonitorClientBs traceIdGenerator(Id traceIdGenerator) {
        this.traceIdGenerator = traceIdGenerator;
        return this;
    }

    public String envId() {
        return envId;
    }

    public MonitorClientBs envId(String envId) {
        this.envId = envId;
        return this;
    }

    public int maxBatchSize() {
        return maxBatchSize;
    }

    public MonitorClientBs maxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }

    public long initDelaySeconds() {
        return initDelaySeconds;
    }

    public MonitorClientBs initDelaySeconds(long initDelaySeconds) {
        this.initDelaySeconds = initDelaySeconds;
        return this;
    }

    public long periodSeconds() {
        return periodSeconds;
    }

    public MonitorClientBs periodSeconds(long periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    /**
     * 初始化
     * @return 客户端
     * @since 1.0.0
     */
    public MonitorClient init() {
        MonitorClient client = new MonitorClient();
        client.setSaltKey(saltKey);
        client.setEnvId(envId);
        client.setTraceIdGenerator(traceIdGenerator);
        client.setServerAddress(serverAddress);
        client.setSystemId(systemId);
        client.setMaxBatchSize(maxBatchSize);
        client.setInitDelaySeconds(initDelaySeconds);
        client.setPeriodSeconds(periodSeconds);
        client.init();

        return client;
    }

}
