/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.monitor.client.java.core;

import com.github.houbb.hibernator.valid.util.ValidHelper;
import com.github.houbb.id.api.Id;
import com.github.houbb.monitor.client.api.request.component.MonitorLogItem;
import com.github.houbb.monitor.client.java.thread.MonitorServerPushThread;
import com.github.houbb.monitor.client.java.thread.MonitorServerPushThreadConfig;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MonitorClient {
    private String systemId;
    private String serverAddress;
    private String saltKey;
    private Id traceIdGenerator;
    private String envId;
    private int maxBatchSize;
    private long initDelaySeconds;
    private long periodSeconds;
    private final Queue<MonitorLogItem> itemQueue = new ArrayDeque<MonitorLogItem>();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public void init() {
        MonitorServerPushThreadConfig config = new MonitorServerPushThreadConfig();
        config.setQueue(this.itemQueue);
        config.setMaxBatchSize(this.maxBatchSize);
        config.setSaltKey(this.saltKey);
        config.setEnvId(this.envId);
        config.setTraceIdGenerator(this.traceIdGenerator);
        config.setSystemId(this.systemId);
        config.setServerAddress(this.serverAddress);
        MonitorServerPushThread runnable = new MonitorServerPushThread(config);
        this.scheduledExecutorService.scheduleAtFixedRate(runnable, this.initDelaySeconds, this.periodSeconds, TimeUnit.SECONDS);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getSaltKey() {
        return this.saltKey;
    }

    public void setSaltKey(String saltKey) {
        this.saltKey = saltKey;
    }

    public Id getTraceIdGenerator() {
        return this.traceIdGenerator;
    }

    public void setTraceIdGenerator(Id traceIdGenerator) {
        this.traceIdGenerator = traceIdGenerator;
    }

    public String getEnvId() {
        return this.envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public long getInitDelaySeconds() {
        return this.initDelaySeconds;
    }

    public void setInitDelaySeconds(long initDelaySeconds) {
        this.initDelaySeconds = initDelaySeconds;
    }

    public long getPeriodSeconds() {
        return this.periodSeconds;
    }

    public void setPeriodSeconds(long periodSeconds) {
        this.periodSeconds = periodSeconds;
    }

    public void add(MonitorLogItem monitorLogItem) {
        ValidHelper.failFast((Object)monitorLogItem);
        this.itemQueue.add(monitorLogItem);
    }
}

